//
//  YHResignDocumentUploadActionCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignDocumentUploadActionCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHResignDocumentUploadActionCell"
    
    var uploadButtonClickEvent: (() -> Void)?
    var sureButtonClickEvent: (() -> Void)?
    
    private lazy var uploadView: YHWorkItemAddView = {
        let view = YHWorkItemAddView()
        view.addBtn.setTitle("上传已签署件".local, for: .normal)
        view.addBtn.setImage(UIImage(named: "document_upload"), for: .normal)
        view.clickBlock = {[weak self] in
            guard let self = self else { return }
            self.uploadButtonClickEvent?()
        }
        return view
    }()
    
    private lazy var promptLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = UIColor.labelTextColor2
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineHeightMultiple = 1.19
        let attributedText = NSAttributedString(
            string: "注意：1.支持PDF、JPEG、JPG、PNG、BMP、TIFF文件格式，文件大小不限制；2.上传成功后会自动更新文件名；3.最多上传10张图片或文件，若有问题联系文案老师",
            attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        )
        label.attributedText = attributedText
        return label
    }()
    
    private lazy var sureButton: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        let buttonName = "确定已上传，提交"
        button.setTitle(buttonName, for: .normal)
        button.setTitle(buttonName, for: .highlighted)
        button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
        button.setTitleColor( UIColor(hex: 0xffffff), for: .highlighted)
        button.addTarget(self, action: #selector(sureButtonClicked), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.backgroundColor = .brandMainColor
        return button
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(uploadName: String, isUploadButtonEnable: Bool = false, isSureButtonEnable: Bool = false, topMargin: CGFloat = 16) {
        uploadView.addBtn.setTitle(uploadName.local, for: .normal)
        uploadView.alpha = isUploadButtonEnable ? 1 : 0.4
        uploadView.addBtn.isEnabled = isUploadButtonEnable
        
        sureButton.alpha = isSureButtonEnable ? 1 : 0.4
        sureButton.isEnabled = isSureButtonEnable
        
        uploadView.snp.remakeConstraints { make in
            make.top.equalToSuperview().offset(topMargin)
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(45)
        }
    }
}

extension YHResignDocumentUploadActionCell {
    
    @objc private func sureButtonClicked() {
        sureButtonClickEvent?()
    }
    
    private func setupUI() {
        updateCellCorner(.bottom)
        subContainerView.addSubview(uploadView)
        subContainerView.addSubview(promptLabel)
        subContainerView.addSubview(sureButton)
        
        uploadView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(45)
        }
        
        promptLabel.snp.makeConstraints { make in
            make.top.equalTo(uploadView.snp.bottom).offset(16)
            make.left.equalTo(uploadView.snp.left)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
        
        sureButton.snp.makeConstraints { make in
            make.top.equalTo(promptLabel.snp.bottom).offset(16)
            make.left.equalTo(uploadView.snp.left)
            make.right.equalTo(uploadView.snp.right)
            make.bottom.equalToSuperview().offset(-16)
            make.height.equalTo(46)
        }
        
    }
}
