//
//  YHPrincipleUploadFileCell.swift
//  galaxy
//
//  Created by edy on 2024/8/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPrincipleUploadFileCell: UITableViewCell {

    static let cellReuseIdentifier = "YHPrincipleUploadFileCell"
    static let height = 55.0
    
    var fileModel = YHPrincipleContentUrlModel()
    
    var iconImgV: UIImageView!
    var titleLabel: UILabel!
    var timeLabel: UILabel!
    var editBtn: UIButton!
    var editBlock: ((YHPrincipleContentUrlModel) -> Void)?
    var clickBlock: ((YHPrincipleContentUrlModel) -> Void)?

    var isShowEditBtn: Bool = false {
        didSet {
            editBtn.isHidden = !isShowEditBtn
        }
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    @objc func didEditBtnClicked() {
        editBlock?(fileModel)
    }
    
    @objc func didFileClicked() {
        self.clickBlock?(fileModel)
    }
    
    func updateModel(_ model: YHPrincipleContentUrlModel) {
        
        fileModel = model
        titleLabel.text = model.name
        timeLabel.text = "上传于" + model.updated_at
        
        let suffix = model.getFileSuffixName()
        var iconImgName = ""
        
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
            
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
            
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
            
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
            
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
            
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
            
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
            
        } else if suffix == "xls" || suffix == "xlsx" {
            iconImgName = "my_cer_type_excel"
        }
        
        iconImgV.image = UIImage(named: iconImgName)
    }
    
    func setupUI() {
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(didFileClicked))
        self.contentView.addGestureRecognizer(tap)
        
        self.selectionStyle = .none
        iconImgV = UIImageView(image: UIImage(named: "my_cer_type_pdf"))
        contentView.addSubview(iconImgV)
        
        titleLabel = UILabel()
        titleLabel.font = UIFont.PFSC_M(ofSize: 14)
        titleLabel.textColor = UIColor.mainTextColor
        titleLabel.text = "文件名称"
        contentView.addSubview(titleLabel)
        
        timeLabel = UILabel()
        timeLabel.font = UIFont.PFSC_R(ofSize: 11)
        timeLabel.textColor = UIColor.labelTextColor2
        timeLabel.text = "上传于0000.00.00"
        contentView.addSubview(timeLabel)
        
        editBtn = UIButton()
        editBtn.isHidden = true
        editBtn.setImage(UIImage(named: "my_cer_btn_edit"), for: .normal)
        editBtn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        editBtn.addTarget(self, action: #selector(didEditBtnClicked), for: .touchUpInside)
        contentView.addSubview(editBtn)
        
        iconImgV.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(31.0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.bottom.equalTo(self.snp.centerY).offset(-1)
            make.left.equalTo(iconImgV.snp.right).offset(18)
            make.right.equalTo(-16)
            make.height.equalTo(20)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.top.equalTo(self.snp.centerY).offset(1)
            make.left.equalTo(iconImgV.snp.right).offset(18)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
        
        editBtn.snp.makeConstraints { make in
            make.width.height.equalTo(16)
            make.centerY.equalToSuperview()
            make.right.equalTo(-20)
        }
    }
}
