//
//  YHSurveyContentModel.swift
//  galaxy
//
//  Created by alexzzw on 2025/3/28.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation
import SmartCodable

// MARK: - YHSurveyContainerModel

class YHSurveyContainerModel: SmartCodable {
    var surveyContent: YHSurveyContentModel = YHSurveyContentModel()
    // 0老用户1新用户
    var type: Int = 0
    var defaultAnswers: [YHSurveyDefaultAnswers] = []
    
    var isNewCustomer: Bool {
        return type == 1
    }

    enum CodingKeys: String, CodingKey {
        case surveyContent = "survey_content"
        case type
        case defaultAnswers = "default_answers"
    }

    required init() {
    }
}

// MARK: - YHSurveyDefaultAnswers

class YHSurveyDefaultAnswers: SmartCodable {
    var questionKey: String = ""
    var optionKey: [String] = []

    enum CodingKeys: String, CodingKey {
        case questionKey = "question_key"
        case optionKey = "option_key"
    }

    required init() {
    }
}

// MARK: - YHSurveyContentModel

class YHSurveyContentModel: SmartCodable {
    /// 问卷ID
    var id: String = ""
    /// 问题列表
    var questions: [YHSurveyQuestionItem] = []
    /// 问卷备注
    var remark: String = ""
    /// 问卷标题
    var title: String = ""

    required init() {
    }
}

// MARK: - YHSurveyQuestionItem

class YHSurveyQuestionItem: SmartCodable {
    /// 业务key，唯一标识一个问券的一个问题
    var businessKey: String = ""
    /// 问题ID
    var id: String = ""
    /// 是否必须回答 0:否 1:是
    var isRequired: Int = 0
    /// 最多允许上传的文件数量 仅对文件上传题有效
    var maxFileCount: Int = 0
    /// 问题序号
    var number: Int = 0
    /// repeated article.AnswerItem show_when = 8 [json_name = "show_when"]; //
    /// 旧版show_when，即将废弃，请转用show_when_v1 仅当某个或某几个问题答案为XXX时才展示 不同项之间是且关系，选项列表
    var options: [YHSurveyQuestionOptionItem] = []
    /// 问题备注
    var remark: String = ""
    var showWhenV1: YHSurveyQuestionItemShowWhenV1 = YHSurveyQuestionItemShowWhenV1()
    /// 问题标题
    var title: String = ""
    /// 问题类型：1:单选 2:多选 3:文本输入 4:文件上传
    var type: Int = 0

    enum CodingKeys: String, CodingKey {
        case id
        case number
        case options
        case remark
        case title
        case type
        case isRequired = "is_required"
        case maxFileCount = "max_file_count"
        case showWhenV1 = "show_when_v1"
        case businessKey = "business_key"
    }

    required init() {
    }
}

// MARK: - YHSurveyQuestionOptionItem

class YHSurveyQuestionOptionItem: SmartCodable {
    /// 业务key，唯一标识一个问题的一个选项
    var businessKey: String = ""
    /// 选项ID
    var id: String = ""
    /// 跳转的目标问题id，仅当 jump_type=2 时有效
    var jumpQuestionId: String = ""
    /// 跳转逻辑 0:无需特殊跳转 1:结束问卷 2:跳到某题
    var jumpType: Int = 0
    /// 选中该选项后是否需要额外填写说明 0:无需 1:选填 2:必填
    var needExtra: Int = 0
    /// 选项序号
    var number: Int = 0
    /// 选项备注
    var remark: String = ""
    /// 该选项对应得分，业务有需要时可用
    var score: Int = 0
    /// 选项标题
    var title: String = ""

    enum CodingKeys: String, CodingKey {
        case id
        case number
        case remark
        case score
        case title
        case needExtra = "need_extra"
        case jumpType = "jump_type"
        case jumpQuestionId = "jump_question_id"
        case businessKey = "business_key"
    }

    required init() {
    }
}

// MARK: - YHSurveyQuestionItemShowWhenV1

class YHSurveyQuestionItemShowWhenV1: SmartCodable {
    var conditions: [YHSurveyQuestionConditionItem] = []
    /// 关系 and/or
    var relation: String = ""
    
    var orArray: [YHSurveyQuestionAndOptions] = []
    var andArray: [YHSurveyQuestionAndOptions] = []

    required init() {
    }
    
    func getConitionArray() -> [YHSurveyQuestionAndOptions] {
        var questionAndOptions: [YHSurveyQuestionAndOptions] = []
        conditions.forEach { conditionItem in
            var optionIds: Set<String> = []
            let options = conditionItem.options
            /// 选项为空，任意选一个即可
            if conditionItem.isAnyAnswerAllowed {
                let questionAndOption = YHSurveyQuestionAndOptions.init(questionsId: conditionItem.questionId, optionIds: [])
                questionAndOptions.append(questionAndOption)
            } else {
                if options.relation == "and" {
                    optionIds.formUnion(options.list.compactMap {
                        $0.optionId
                    })
                    
                    let questionAndOption = YHSurveyQuestionAndOptions.init(questionsId: conditionItem.questionId, optionIds: optionIds)
                    questionAndOptions.append(questionAndOption)
                    
                } else if options.relation == "or" {
                    questionAndOptions.append(contentsOf: options.list.compactMap {
                        return YHSurveyQuestionAndOptions.init(questionsId: conditionItem.questionId, optionIds: [$0.optionId])
                    })
                }
            }
        }
        return questionAndOptions
    }
    
    func didFinishMapping() {
        if relation == "or" {
            orArray = getConitionArray()
        } else if relation == "and" {
            andArray = getConitionArray()
        }
    }
}

// MARK: - YHSurveyQuestionConditionItem

class YHSurveyQuestionConditionItem: SmartCodable {
    /// 选中的选项ID与额外说明 仅对单选/多选有效且必需，单选时此项长度为1 兼容旧版 todo 去除
    var optionExtra: [YHSurveyConditionOptionExtra] = []
    var options: YHSurveyConditionOptions = YHSurveyConditionOptions()
    /// 问题ID
    var questionId: String = ""
    /// 问题类型：1:单选 2:多选 3:文本输入 4:文件上传
    var questionType: Int = 0
    var isAnyAnswerAllowed: Bool = false

    enum CodingKeys: String, CodingKey {
        case options
        case optionExtra = "option_extra"
        case questionId = "question_id"
        case questionType = "question_type"
        case isAnyAnswerAllowed = "is_any_answer_allowed"
    }

    required init() {
    }
}

// MARK: - YHSurveyConditionOptionExtra

class YHSurveyConditionOptionExtra: SmartCodable {
    /// 问题选项额外说明 选中该选项后必需填写额外说明时必需
    var extra: String = ""
    /// 选项ID 必需
    var optionId: String = ""
    /// 选项标题 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var title: String = ""
    
    /// 选项key 必需
    var optionKey: String = ""
    
    init(extra: String, optionId: String, title: String, optionKey: String) {
        self.extra = extra
        self.optionId = optionId
        self.title = title
        self.optionKey = optionKey
    }

    enum CodingKeys: String, CodingKey {
        case extra
        case title
        case optionId = "option_id"
        case optionKey = "option_key"
    }

    required init() {
    }
}

// MARK: - YHSurveyConditionOptions

class YHSurveyConditionOptions: SmartCodable {
    /// 选项ID与额外说明的列表 单选时此项长度为1
    var list: [YHSurveyConditionOptionsItem] = []
    /// 关系 and/or
    var relation: String = ""

    required init() {
    }
}

// MARK: - YHSurveyConditionOptionsItem

class YHSurveyConditionOptionsItem: SmartCodable {
    var extra: YHSurveyOptionsItemExtra = YHSurveyOptionsItemExtra()
    /// 选项ID
    var optionId: String = ""

    enum CodingKeys: String, CodingKey {
        case extra
        case optionId = "option_id"
    }

    required init() {
    }
}

// MARK: - YHSurveyOptionsItemExtra

class YHSurveyOptionsItemExtra: SmartCodable {
    /// 选项额外说明的内容 仅当 额外说明的判断方式为2时才有效
    var content: String = ""
    /// 选项额外说明的判断方式 0:无需判断 1:必须非空，不管具体值 2:必须为特定值
    var verifyType: Int = 0

    enum CodingKeys: String, CodingKey {
        case content
        case verifyType = "verify_type"
    }

    required init() {
    }
}

struct YHSurveyQuestionAndOptions: SmartCodable, Equatable {
    var questionsId: String = ""
    var optionIds: Set<String> = []
    
    static func == (lhs: YHSurveyQuestionAndOptions, rhs: YHSurveyQuestionAndOptions) -> Bool {
        return lhs.questionsId == rhs.questionsId && lhs.optionIds == rhs.optionIds
    }
}
