//
//  YHResignUploadTravelCardViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/10/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignUploadTravelCardViewModel: YHBaseViewModel {
    
    // 列表信息
    var arrTravelDocs: YHResignUploadTravelCardListModel = YHResignUploadTravelCardListModel()
    
    // 旅行证件嫌弃
    var travelDetailModel: YHTravelDocsPreparationDetailModel?
    
}

extension YHResignUploadTravelCardViewModel {
    
    // 获取旅行证件准备列表
    func getTravelDocsList(orderID: Int, renewalId: Int, callBackBlock: @escaping (_ success: Bool, _ err: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderID, "renewal_id": renewalId]

        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelCard.list
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignUploadTravelCardListModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.travelDetailModel = nil
                    callBackBlock(false, err)
                    return
                }
                self.arrTravelDocs = resultModel
                callBackBlock(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 获取旅行证件详情
    func getTravelDocsDetailInfo(param: [String: Any], callBackBlock: @escaping (_ success: Bool, _ err: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelDocsPreparation.getTravelDocsDetailApi
        _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHTravelDocsPreparationDetailModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.travelDetailModel = nil
                    callBackBlock(false, err)
                    return
                }
                self.travelDetailModel = resultModel
                for item in resultModel.list {
                    if let item = item {
                        item.latest_validaty_date = self.travelDetailModel?.latest_validaty_date ?? ""
                        item.china_travel_latest_validaty_date = self.travelDetailModel?.china_travel_latest_validaty_date ?? ""
                        item.age = resultModel.age
                    }
                }
                callBackBlock(true, nil)
                
            } else {
                self.travelDetailModel = nil
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            self.travelDetailModel = nil
            callBackBlock(false, err)
        }
    }
    
    // 保存旅行证件
    func saveTravelDocsInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelDocsPreparation.saveTravelDocsInfoApi
        
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else {
                callBackBlock(false, nil)
                return
            }
            
            if json.code == 200 {
                
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
}
