//
//  YHMyEducationCell.swift
//  galaxy
//
//  Created by edy on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyEducationCell: UITableViewCell {
    typealias EditBlock = () -> Void
    var editBlock: EditBlock?
    var hiddenBtnBlock: (() -> Void)?
    static let cellReuseIdentifier = "YHMyEducationCell"
    var userModel: YHUserNameCardInfo = YHUserNameCardInfo() {
        didSet {
            
            self.editBtn.isHidden = !self.userModel.isCurrentUser
            self.collegeLabel.textColor = UIColor.mainTextColor
            self.detailLabel.textColor = UIColor.mainTextColor70
            if !self.userModel.college.isEmpty {
                self.collegeLabel.text = self.userModel.college
            } else {
                self.collegeLabel.text = ""
                if self.userModel.isCurrentUser {
                    self.collegeLabel.text = "填写院校名称"
                    self.collegeLabel.textColor = UIColor.mainTextColor30
                }
            }
            
            var detail = self.userModel.major
            var isFirst = true
            if !detail.isEmpty {
                isFirst = false
            }
            if !self.userModel.background.isEmpty {
                if isFirst {
                    detail += self.userModel.background
                } else {
                    detail += "·" + self.userModel.background
                }
            }
        
            if !detail.isEmpty {
                self.detailLabel.text = detail
            } else {
                self.detailLabel.text = ""
                if self.userModel.isCurrentUser {
                    self.detailLabel.text = "填写专业 · 填写学位"
                    self.detailLabel.textColor = UIColor.mainTextColor30
                }
            }
            
            if self.userModel.isCurrentUser {
                self.hiddenBtn.isHidden = !self.userModel.isHiddenEducation
                
            } else {
                self.hiddenBtn.isHidden = true
            }
        }
    }
    
    lazy var cardView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 6.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "教育经历"
        label.textColor = UIColor(hexString: "#222222")
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 17)
        return label
    }()
    
    lazy var collegeLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.numberOfLines = 0
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandGrayColor7
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.numberOfLines = 0
        return label
    }()
    
    lazy var editBtn: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "people_card_edit"), for: .normal)
        btn.addTarget(self, action: #selector(edit), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        return btn
    }()
    
    lazy var hiddenBtn: UIButton = {
        let btn = UIButton()
        btn.isHidden = true
        btn.backgroundColor = UIColor.init(hex: 0xF4F6FA)
        btn.layer.cornerRadius = 3.0
        btn.setImage(UIImage(named: "people_card_hidden"), for: .normal)
        btn.setTitle("已隐藏", for: .normal)
        btn.setTitleColor(UIColor.mainTextColor50, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 10)
        btn.titleEdgeInsets = UIEdgeInsets(top: 0, left: -11, bottom: 0, right: 11)
        btn.imageEdgeInsets = UIEdgeInsets(top: 0, left: 31, bottom: 0, right: -31)
        btn.addTarget(self, action: #selector(didHiddenBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .brandGrayColor3
        return v
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    @objc func didHiddenBtnClicked() {
        self.hiddenBtnBlock?()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        
        self.contentView.addSubview(self.cardView)
        cardView.addSubview(self.titleLabel)
        cardView.addSubview(self.collegeLabel)
        cardView.addSubview(self.detailLabel)
        cardView.addSubview(self.editBtn)
        cardView.addSubview(self.hiddenBtn)
        cardView.addSubview(lineView)

        cardView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(24)
            make.height.equalTo(24)
        }
        
        editBtn.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.right.equalTo(-20)
            make.centerY.equalTo(titleLabel)
        }
        
        hiddenBtn.snp.makeConstraints { make in
            make.width.equalTo(50)
            make.height.equalTo(18)
            make.centerY.equalTo(self.titleLabel)
            make.left.equalTo(self.titleLabel.snp.right).offset(8)
            make.right.lessThanOrEqualTo(self.editBtn.snp.left).offset(-20)
        }
        
        collegeLabel.snp.makeConstraints { make in
            make.top.equalTo(self.titleLabel.snp.bottom).offset(16)
            make.left.equalTo(20)
            make.right.equalTo(-20)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(self.collegeLabel.snp.bottom).offset(8)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.bottom.equalTo(-24)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.bottom.equalTo(0)
            make.height.equalTo(1)
        }

    }
    
    @objc func edit() {
        if let block = editBlock {
            block()
        }
    }
}
