//
//  YHPayMemberContentItems.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHPayMemberContentItems: UIView {
    var  dataModel: YHVisaPaymentModel? {
        didSet {
            updateUI()
        }
    }
    
    // 用来自动布局
    lazy var fakeView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

private extension YHPayMemberContentItems {
    func setupUI() {
        backgroundColor = .contentBkgColor
        layer.cornerRadius = kCornerRadius3
        clipsToBounds = true
    }
}

extension YHPayMemberContentItems {
    func updateUI() {
        
        guard let model = dataModel else { return }
        
        whiteContentView.removeSubviews()
        removeSubviews()
        
        addSubview(whiteContentView)
        whiteContentView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.right.equalToSuperview().offset(-14)
            make.left.equalToSuperview().offset(14)
        }
        
        let item = YHPayMemberContentItem()
        whiteContentView.addSubview(item)
        item.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.right.equalToSuperview()
        }
        item.updateUI(title: "档案号：", detail: model.file_num, showBtn: true, needBold: true)
        
        var lastView: UIView = item
        
        // 支付状态 7-待缴费 8-已缴费 9-电子签证已过期
        if model.pay_status == 7 || model.pay_status == 9 {
            do {
                let item = YHPayMemberContentItem()
                whiteContentView.addSubview(item)
                item.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                    make.left.right.equalToSuperview()
                }
                
                if model.min_pay_time.isYHEmpty() {
                    item.updateUI(title: "可缴费时间段：", detail: "\(model.max_pay_time)前", showBtn: false)
                    
                } else {
                    item.updateUI(title: "可缴费时间段：", detail: "\(model.min_pay_time) - \(model.max_pay_time)", showBtn: false)
                }
                
                lastView = item
            }
            
            do {
                let item = YHPayMemberContentItem()
                whiteContentView.addSubview(item)
                item.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                    make.left.right.equalToSuperview()
                }
                if model.fee_money.count > 0 {
                    item.updateUI(title: "缴费金额：", detail: "\(model.fee_money)", showBtn: false)
                } else {
                    item.updateUI(title: "缴费金额：", detail: "\(model.fee_hkd)港币（≈\(model.fee_rmb)人民币)", showBtn: false)
                }
                
                lastView = item
            }
            
        } else if model.pay_status == 8 {
            
            do {
                let item = YHPayMemberContentItem()
                whiteContentView.addSubview(item)
                item.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                    make.left.right.equalToSuperview()
                }
                if model.fee_money.count > 0 {
                    item.updateUI(title: "缴费金额：", detail: "\(model.fee_money)", showBtn: false)
                } else {
                    item.updateUI(title: "缴费金额：", detail: "\(model.fee_hkd)港币（≈\(model.fee_rmb)人民币)", showBtn: false)
                }
                
                lastView = item
            }
            
            do {
                whiteContentView.addSubview(lineView)
                lineView.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                    make.height.equalTo(1)
                    make.left.right.equalToSuperview()
                }
                lastView = lineView
            }
            
            do {
                let item = YHPayMemberContentItem()
                whiteContentView.addSubview(item)
                item.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                    make.left.right.equalToSuperview()
                }
                
                if model.receipt.isEmpty {
                    item.updateUI(title: "缴费电子签证：", detail: "暂未查询到结果", oneLine: false, showBtn: false)
                } else {
                    item.updateUI(title: "缴费电子签证：", detail: model.receipt, oneLine: false, showBtn: true)
                }
                
                lastView = item
            }
        }
        
        whiteContentView.addSubview(fakeView)
        fakeView.snp.makeConstraints { make in
            make.top.equalTo(lastView.snp.bottom).offset(kMargin)
            make.height.equalTo(1)
            make.left.bottom.right.equalToSuperview()
        }
        
    }
}
