//
//  YHEmploymentVerificationAvailableCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEmploymentVerificationAvailableCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHEmploymentVerificationAvailableCell"
    
    private lazy var dotIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "red_dot_6"))
        return imageView
    }()

    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "可提供的在职公司"
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "请选择"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var infoFailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .failColor
        label.text = "请选择"
        return label
    }()
    
    private lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imageView
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(detail: String?, needShowFailButton: Bool) {
        infoDetailLabel.text = detail
        updateContentState((detail?.count ?? 0) > 0)
        updateFailLabel(needShowFailButton)
    }
}

extension YHEmploymentVerificationAvailableCell {
    private func updateFailLabel(_ needShowFailButton: Bool) {
        if needShowFailButton {
            infoFailLabel.isHidden = false
            infoTitleLabel.snp.remakeConstraints { make in
                make.left.equalTo(dotIcon.snp.right).offset(2)
                make.top.equalToSuperview().offset(16)
            }
            infoFailLabel.snp.remakeConstraints { make in
                make.top.equalTo(infoTitleLabel.snp.bottom).offset(6)
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            infoFailLabel.isHidden = true
            infoTitleLabel.snp.remakeConstraints { make in
                make.left.equalTo(dotIcon.snp.right).offset(2)
                make.top.equalToSuperview().offset(16)
                make.bottom.lessThanOrEqualToSuperview().offset(-16)
            }
            infoFailLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
    }
    
    private func updateContentState(_ isNotBlank: Bool) {
        if !isNotBlank {
            infoDetailLabel.text = "请选择"
            infoDetailLabel.font = .PFSC_R(ofSize: 14)
            infoDetailLabel.textColor = UIColor(hexString: "#B9C1CC")
        } else {
            infoDetailLabel.font = .PFSC_M(ofSize: 14)
            infoDetailLabel.textColor = UIColor.mainTextColor
        }
    }
    
    private func setupUI() {
        updateCellCorner(.bottom)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(dotIcon)
        subContainerView.addSubview(rightArrowIcon)
        subContainerView.addSubview(infoFailLabel)
        
        dotIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightArrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        dotIcon.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.height.width.equalTo(6)
            make.centerY.equalTo(infoTitleLabel)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(dotIcon.snp.right).offset(2)
            make.top.equalToSuperview().offset(16)
            make.bottom.lessThanOrEqualToSuperview().offset(-16)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(20)
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalTo(rightArrowIcon.snp.left)
            make.top.greaterThanOrEqualToSuperview().offset(16)
            make.bottom.lessThanOrEqualToSuperview().offset(-16)
        }
        
        infoFailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-16)
        }
        infoFailLabel.isHidden = true
        
        updateContentState(false)
    }
}
