//
//  YHBasePlayerViewController.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import AgoraRtcKit
import AVKit
import UIKit

class YHBasePlayerViewController: YHBaseViewController {
    // MARK: - Properties
    weak var player: YHPlayer?
    var playbackInfo: YHPlayerManager.PlaybackInfo?
    
    // 播放器设置
    var currentPlayingURL: String?
    var currentVideoTitle: String?
    
    // MARK: - UI Components
    lazy var containerView: UIView = {
        let view = UIView()
        view.backgroundColor = .black
        return view
    }()
    
    lazy var playerView: UIView = {
        let view = UIView()
        view.backgroundColor = .black
        return view
    }()
    
    lazy var topBarView: YHPlayerTopBarView = {
        let view = YHPlayerTopBarView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: k_Height_NavigationtBarAndStatuBar))
        return view
    }()
    
    // MARK: - Lifecycle
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        gk_navBarAlpha = 0
        gk_navigationBar.isHidden = true
        view.backgroundColor = .black
        UIApplication.shared.isIdleTimerDisabled = true
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        gk_navBarAlpha = 1
        gk_navigationBar.isHidden = false
        view.backgroundColor = .black
        UIApplication.shared.isIdleTimerDisabled = false
    }
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    // MARK: - Setup
    private func setupUI() {
        gk_navBarAlpha = 0
        gk_navigationBar.isHidden = true
        view.backgroundColor = .black
        view.addSubview(containerView)
        containerView.addSubview(playerView)
        containerView.addSubview(topBarView)
        setupConstraints()
    }
    
    private func setupConstraints() {
        containerView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        playerView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        topBarView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(k_Height_NavigationtBarAndStatuBar)
        }
    }
}
