//
//  YHActivityTipsItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityTipsItemView: UIView {

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    var tipsText: String? {
        didSet {
            updateUI2()
        }
    }
    
    var showLineFlag: Bool = true
    
    var dataModel: YHActivityDetailModel? {
        didSet {
            updateUI()
        }
    }
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    lazy var nameLabel: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_M(ofSize: 17)
        nameLabel.text = "温馨提示"
        nameLabel.numberOfLines = 0
        return nameLabel
    }()
    
    lazy var describeLable: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor70
        nameLabel.textAlignment = .left
        nameLabel.lineBreakMode = .byCharWrapping
        nameLabel.font = UIFont.PFSC_R(ofSize: 14)
        nameLabel.text = ""
        nameLabel.numberOfLines = 0
        return nameLabel
    }()
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        bottomLine.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
        if showLineFlag {
            bottomLine.isHidden = false
            nameLabel.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                make.top.equalTo(bottomLine.snp.bottom).offset(24)
            }
        } else {
            bottomLine.isHidden = true
            nameLabel.snp.makeConstraints { make in
                make.top.left.right.equalToSuperview()
            }
        }
        
        describeLable.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(nameLabel.snp.bottom).offset(24)
            
            make.bottom.equalToSuperview()
        }
    }
}

extension YHActivityTipsItemView {
    func updateUI2() {
        guard let txt = tipsText else {
            return
        }
        describeLable.text = txt
        
        // 创建NSMutableAttributedString实例
        let attributedText = NSMutableAttributedString(string: txt)
        
        // 设置行距，这里设置为10.0
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 6.0 // 设置行距
        
        // 将段落样式添加到NSMutableAttributedString
        attributedText.addAttribute(.paragraphStyle, value: paragraphStyle, range: NSRange(location: 0, length: attributedText.length))
        
        // 设置UILabel的attributedText属性
         describeLable.attributedText = attributedText
        layoutIfNeeded()
    }
    
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        describeLable.text = model.tips
        
        // 创建NSMutableAttributedString实例
        let attributedText = NSMutableAttributedString(string: model.tips)
        
        // 设置行距，这里设置为10.0
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 6.0 // 设置行距
        
        // 将段落样式添加到NSMutableAttributedString
        attributedText.addAttribute(.paragraphStyle, value: paragraphStyle, range: NSRange(location: 0, length: attributedText.length))
        
        // 设置UILabel的attributedText属性
         describeLable.attributedText = attributedText
        
        layoutIfNeeded()
    }
    
    func setupUI() {
        addSubview(bottomLine)
        addSubview(nameLabel)
        addSubview(describeLable)
        layoutIfNeeded()
    }
}
