//
//  YHDocumentUploadTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/3/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDocumentUploadTableViewCell: UITableViewCell {
    typealias Block = (YHMyFileMethodType, Int) -> Void
    var block: Block?
    var centerView: UIView!
    var titleLabel: UILabel!
    var topLineView: UIView!
    var promptLabel: UILabel!
    var mainItemView: UIView!
    var bottomView: YHWorkItemAddView!

    var dataSource: YHMyDocumentDetailModel? {
        didSet {
            updateAllViews()
        }
    }
    
    var type: Int = 0 {
        didSet {
            updateAddView()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "上传已签章件"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        promptLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.labelTextColor2
            label.numberOfLines = 0
            label.text = "注意：1.支持PDF、JPEG、JPG、PNG、BMP、TIFF文件格式，文件大小不限制；2.上传成功后会自动更新文件名；3.最多上传10张图片或文件，若有问题可联系文案"
            return label
        }()
        centerView.addSubview(promptLabel)
        promptLabel.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.height.equalTo(60)
            make.bottom.equalTo(-16)
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("上传已签章件".local, for: .normal)
            view.addBtn.setImage(UIImage(named: "document_upload"), for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.block {
                    block(.upload, 0)
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.bottom.equalTo(-92)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(45)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-153)
            make.top.equalTo(52)
        }
        
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        centerView.addSubview(line)
        line.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        mainItemView.removeSubviews()
        if dataSource.writing_document.doc_sign.doc_return_manual.count != 0 {
            bottomView.addBtn.setTitle("继续上传".local, for: .normal)
        } else {
            bottomView.addBtn.setTitle("上传已签章件".local, for: .normal)
        }
        var y = 0
        for i in 0 ..< (dataSource.writing_document.doc_sign.doc_return_manual.count) {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            y += 1
            let data = dataSource.writing_document.doc_sign.doc_return_manual[i]
            let h = 70
            let itemView = YHDocumentFileItemView()
            itemView.index = i
            itemView.type = type
            itemView.docType = dataSource.writing_document.doc_sign.doc_type
            itemView.dataSource = data
            itemView.itemBlock = {[weak self] type, index in
                guard let self = self else { return }
                if let block = block {
                    block(type, index)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(h)
                make.right.equalTo(-18)
            }
            y += h
        }
    }
    
    func updateAddView() {
        if type == 4 {
            self.bottomView.alpha = 0.4
            self.bottomView.addBtn.isEnabled = false
        }
        
        if type == 5 {
            self.bottomView.isHidden = true
            mainItemView.snp.remakeConstraints { make in
                make.left.right.equalToSuperview()
                make.bottom.equalTo(-92)
                make.top.equalTo(52)
            }
        }
    }
}
