//
//  YHUploadCertificateTitleCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHUploadCertificateTitleCell: UITableViewCell {

    static let cellReuseIdentifier = "YHUploadCertificateTitleCell"
    static let cellH: CGFloat = 53.0

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.text = "小白条"
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        
        whiteContentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(1)
        }
        
        whiteContentView.addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.bottom.equalTo(lineView.snp.top)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalToSuperview()
        }
        
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.25) {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
            let path = UIBezierPath(roundedRect: self.bounds, byRoundingCorners: corner, cornerRadii: CGSize(width: 8, height: 8))
            let layer = CAShapeLayer()
            layer.frame = CGRect(x: 0, y: 0, width: KScreenWidth - 16 * 2, height: YHUploadCertificateTitleCell.cellH)
            layer.path = path.cgPath
            self.whiteContentView.layer.mask = layer
            self.whiteContentView.clipsToBounds = true
        }
    }
    
    func updateTitle(_ title: String) {
        titleLable.text = title
    }
}
