//
//  YHResignDocumentType.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHResignDocumentType: Int {
    case powerOfAttorney = 1
    case qmasDoc = 2
    case settlementPlan = 3
    case explanatoryStatement = 4
    
    var title: String {
        switch self {
        case .powerOfAttorney:
            return "代理委托书"
        case .settlementPlan:
            return "定居计划"
        case .explanatoryStatement:
            return "解释说明"
        case .qmasDoc:
            return "QMAS文件"
        }
    }
}
