//
//  YHPlanProductListView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanProductItemView: UIView {
    
    var clickBlock: ((YHPlanProductModel) -> Void)?

    var product: YHPlanProductModel = YHPlanProductModel() {
        didSet {
            titleLabel.text = product.title
            descLabel.text = product.description
            if let url = URL(string: product.img_url) {
                iconImgV.sd_setImage(with: url, placeholderImage: UIImage(named: "plan_product_default"))
            } else {
                iconImgV.image = UIImage(named: "plan_product_default")
            }
        }
    }
    
    lazy var iconImgV: UIImageView = {
        let v = UIImageView()
        v.backgroundColor = .red
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 15)
        lable.text = "XXXXXXXX"
        return lable
    }()
    
    lazy var descLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x8993A2)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.numberOfLines = 0
        lable.text = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
        return lable
    }()
    
    lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imageView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didItemViewClicked() {
        clickBlock?(self.product)
    }
    
    func createUI() {
        
        backgroundColor = .init(hex: 0xF8F9FB)
        let tap = UITapGestureRecognizer(target: self, action: #selector(didItemViewClicked))
        self.addGestureRecognizer(tap)
        
        self.addSubview(iconImgV)
        self.addSubview(titleLabel)
        self.addSubview(descLabel)
        self.addSubview(rightArrowIcon)
        
        iconImgV.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.width.equalTo(iconImgV.snp.height)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgV.snp.right).offset(8)
            make.top.equalTo(8)
            make.height.equalTo(22)
            make.right.equalTo(rightArrowIcon.snp.left).offset(-8)
        }
        
        descLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgV.snp.right).offset(8)
            make.top.equalTo(titleLabel.snp.bottom).offset(2)
            make.height.equalTo(18)
            make.right.equalTo(rightArrowIcon.snp.left).offset(-8)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.width.height.equalTo(16)
            make.centerY.equalToSuperview()
            make.right.equalTo(-8)
        }
    }
}

class YHPlanProductListView: UIView {
    
    var clickBlock: ((YHPlanProductModel) -> Void)?

    var products: [YHPlanProductModel] = [] {
        didSet {
            listView.removeSubviews()
            var lastItemView: YHPlanProductItemView?
            for (index, item) in products.enumerated() {
                let v = YHPlanProductItemView(frame: .zero)
                v.product = item
                v.clickBlock = self.clickBlock
                listView.addSubview(v)
                v.snp.makeConstraints { make in
                    make.left.right.equalToSuperview()
                    make.height.equalTo(58.0)
                    if let last = lastItemView {
                        make.top.equalTo(last.snp.bottom).offset(8)
                    } else {
                        make.top.equalToSuperview()
                    }
                    if index == products.count-1 {
                        make.bottom.equalToSuperview()
                    }
                }
                lastItemView = v
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0xAE6C32)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 13)
        lable.text = "增购以下产品可提升生活联系"
        return lable
    }()
    
    lazy var listView: UIView = {
        let v = UIView()
        return v
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        backgroundColor = .clear
        self.addSubview(titleLabel)
        self.addSubview(listView)
        
        titleLabel.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(18)
        }
        
        listView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
            make.left.right.bottom.equalToSuperview()
        }
    }

}
