//
//  YHMessageBellView.swift
//  galaxy
//
//  Created by edy on 2024/6/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMessageBellView: UIView {

    static let width  = 53.0
    static let height = 36.0
    
    var unreadCount: Int = 0 {
        didSet {
            self.unreadLabel.isHidden = (self.unreadCount <= 0)
            if 0 < self.unreadCount && self.unreadCount < 100 {
                self.unreadLabel.text = "\(self.unreadCount)"
            } else if self.unreadCount >= 100 {
                self.unreadLabel.text = "99+"
            }
            var width = 16.0
            if 10 <= self.unreadCount && self.unreadCount < 100 {
                width = 22.0
            } else if self.unreadCount >= 100 {
                width = 30.0
            }
            self.unreadLabel.snp.updateConstraints { make in
                make.width.equalTo(width)
            }
        }
    }
    
    lazy var bellImgV: UIImageView = {
        let imgV = UIImageView(image: UIImage(named: "msg_bell"))
        return imgV
    }()
    
    lazy var unreadLabel: UILabel = {
        let label = UILabel()
        label.textColor = .white
        label.textAlignment = .center
        label.backgroundColor = .failColor
        label.font = .PFSC_M(ofSize: 10)
        label.layer.cornerRadius = 8.0
        label.clipsToBounds = true
        label.isHidden = true
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    static func bellView() -> YHMessageBellView {
        let view = YHMessageBellView(frame: CGRect(x: 0, y: 0, width: Self.width, height: Self.height))
        return view
    }
    
    func createUI() {
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(didBellBtnClicked))
        self.addGestureRecognizer(tap)
        
        self.addSubview(self.bellImgV)
        self.addSubview(self.unreadLabel)
        
        self.bellImgV.snp.makeConstraints { make in
            make.width.height.equalTo(21.0)
            make.left.equalTo(12)
            make.centerY.equalToSuperview()
        }
        
        self.unreadLabel.snp.makeConstraints { make in
            make.left.equalTo(self.bellImgV).offset(10)
            make.bottom.equalTo(self.bellImgV.snp.top).offset(8.0)
            make.height.equalTo(16.0)
            make.width.equalTo(16.0)
        }
    }
    
    @objc func didBellBtnClicked() {
        if YHLoginManager.shared.isLogin() == false {
            YHOneKeyLoginManager.shared.oneKeyLogin()
            return
        }
        
        NotificationCenter.default.post(name: YhConstant.YhNotification.clickHomeMsgNotifiction, object: nil)
        let vc = YHMessageListVC()
        UIViewController.current?.navigationController?.pushViewController(vc)
    }
}
