//
//  YHResignDocumentViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHResignDocumentUploadSignedDocType: Int {
    case upload = 1
    case submit = 2
}

class YHResignDocumentViewModel: YHBaseViewModel {
    var documentList: YHResignDocumentListModel = YHResignDocumentListModel()
    
    func getDocumentList(orderId: Int, id: Int, callback: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params = ["order_id": orderId, "id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.resignDocumentList
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignDocumentListModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(false, err)
                    return
                }
                self.documentList = resultModel
                callback(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(false, err)
            }
            
        } failBlock: { err in
            callback(false, err)
        }
    }
    
    func getDocumentDetail(docId: Int, callback: @escaping (_ documentModel: YHResignDocumentCompleteModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.resginDocumentDetail + "/\(docId)"
        _ = YHNetRequest.getRequest(url: strUrl, params: [:]) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignDocumentCompleteModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func resginDocumentSignature(_ docId: Int, _ userMobile: String?, callBackBlock: @escaping (_ signatureModel: YHResignDocumentSignatureModel?, _ error: YHErrorModel?) -> Void ) {
        var params: [String: Any] = ["docId": docId]
        if let userMobile = userMobile {
            params["userMobile"] = userMobile
        }
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.resginDocumentSignature
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignDocumentSignatureModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(nil, err)
                    return
                }
                callBackBlock(resultModel, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(nil, err)
            }
        } failBlock: { err in
            callBackBlock(nil, err)
        }
    }
    
    func submitResginDocument(_ docId: Int, _ userMobile: String?, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void ) {
        var params: [String: Any] = ["docId": docId]
        if let userMobile = userMobile {
            params["userMobile"] = userMobile
        }
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.submitResginDocument
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func previewResginDocument(docId: Int, callback: @escaping (_ documentModel: YHResignDocumentPreviewModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.previewResginDocument + "/\(docId)"
        _ = YHNetRequest.getRequest(url: strUrl, params: [:]) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignDocumentPreviewModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func getOriginalDoc(docId: Int, callback: @escaping (_ documentModel: YHResignDocumentPreviewModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.getOriginalDoc
        _ = YHNetRequest.getRequest(url: strUrl, params: ["docId": docId]) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignDocumentPreviewModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func getResginDocumentUrl(docId: Int, isEditable: Bool, callback: @escaping (_ documentModel: YHResignDocumentPreviewModel?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": docId, "type": isEditable ? 1 : 0]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.getResginDocumentUrl
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignDocumentPreviewModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func sendOriginalDoc(_ docId: Int, _ email: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void ) {
        let params: [String: Any] = ["docId": docId, "email": email]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.sendOriginalDoc
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func uploadSignedDoc(_ docId: Int, type: YHResignDocumentUploadSignedDocType, _ signedDocument: [YHResignDocumentUploadSignedDocument], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void ) {
        let docDics = signedDocument.map {
            $0.getUploadDict()
        }
        let params: [String: Any] = ["docId": docId,
                                      "type": type.rawValue,
                                      "signedDocument": docDics]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignDocument.uploadSignedDoc
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
