//
//  YHGCSignatureToActionTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCSignatureToActionTableViewCell: UITableViewCell {
    typealias Block = (YHMyFileMethodType) -> Void
    var block: Block?
    var centerView: UIView!
    var titleLabel: UILabel!
    var topLineView: UIView!
    var bottomView: UIView!
    var bottomLeftLineView: UIView!
    var bottomRightLineView: UIView!
    var fileImageView: UIImageView!
    var fileNameLabel: UILabel!
    var shareButton: UIButton!
    var editButton: UIButton!
    var submitButton: UIButton!
    var lookButton: UIButton!
    var miniPath: String = ""
    var flagLabel: UILabel!
    var dataSource: YHMySignatureDetailModel? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        let width = (KScreenWidth - 32)/2.0
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "文书稿件"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        flagLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 10)
            label.textColor = UIColor.brandMainColor
            label.text = "待签署"
            label.textAlignment = .center
            label.backgroundColor = UIColor(hex: 0xebf0f9)
            return label
        }()
        centerView.addSubview(flagLabel)
        flagLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.centerY.equalTo(titleLabel.snp.centerY)
            make.height.equalTo(18)
            make.width.equalTo(38)
        }
        
        topLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(topLineView)
        topLineView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(1)
            make.top.equalTo(52)
        }
        
//        shareButton = {
//            let button = UIButton(type: .custom)
//            button.setBackgroundImage(UIImage(named: "share_mini_program"), for: .normal)
//            button.addTarget(self, action: #selector(shareButtonClick), for: .touchUpInside)
//            button.isHidden = true
//            return button
//        }()
//        centerView.addSubview(shareButton)
//        shareButton.snp.makeConstraints { make in
//            make.top.equalTo(18)
//            make.right.equalTo(-24)
//            make.height.equalTo(20)
//            make.width.equalTo(80)
//        }
        
        bottomView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.left.equalToSuperview()
            make.height.equalTo(1)
            make.top.equalTo(115)
        }
        
        editButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("签署", for: .normal)
            button.addTarget(self, action: #selector(editButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(editButton)
        editButton.snp.makeConstraints { make in
            make.left.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.width.equalToSuperview()
        }
        
        submitButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("查看", for: .normal)
            button.addTarget(self, action: #selector(submitButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(submitButton)
        submitButton.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.left.equalToSuperview()
            make.width.equalTo(width)
        }
        
        lookButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("下载", for: .normal)
            button.addTarget(self, action: #selector(lookButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(lookButton)
        lookButton.snp.makeConstraints { make in
            make.right.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.width.equalTo(width)
        }
        
        fileImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "")
            return view
        }()
        centerView.addSubview(fileImageView)
        fileImageView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(31)
        }
        
        fileNameLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            label.text = "雇主的推荐信(仅签字)华为科技有限公司.doc"
            return label
        }()
        centerView.addSubview(fileNameLabel)
        fileNameLabel.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(67)
            make.height.equalTo(40)
            make.centerY.equalToSuperview()
        }
        
        bottomLeftLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomLeftLineView)
        bottomLeftLineView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.equalTo(1)
            make.centerY.equalTo(editButton.snp.centerY)
            make.height.equalTo(16)
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        let suffix = dataSource.signFileOrigin.pathExtension.lowercased()
        var iconImgName = "my_cer_type_pdf"
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
        } else if suffix == "xls" || suffix == "xlsx" {
            iconImgName = "my_cer_type_excel"
        }
        fileImageView.image = UIImage(named: iconImgName)
        var name = ""
        if dataSource.docType == 1000 {
            name = "代理委托书"
        } else if dataSource.docType == 1001 {
            name = "赴港同意书"
        } else if dataSource.docType == 1002 {
            name = "声明书"
        }
        fileNameLabel.text = name
        // 1003-待签署; 1004-已签署; 1005-待审核; 1006-已驳回; 1007-已完成
        if dataSource.docStatus == 1000 || dataSource.docStatus == 1001 {
            bottomLeftLineView.isHidden = true
            editButton.isHidden = false
            submitButton.isHidden = true
            lookButton.isHidden = true
            flagLabel.textColor = UIColor.brandMainColor
            flagLabel.text = "待补充"
            flagLabel.backgroundColor = UIColor(hex: 0xebf0f9)
            editButton.setTitle("补充信息", for: .normal)
        } else if dataSource.docStatus == 1002 {
            bottomLeftLineView.isHidden = true
            editButton.isHidden = true
            submitButton.isHidden = false
            lookButton.isHidden = true
            submitButton.snp.remakeConstraints { make in
                make.bottom.equalToSuperview()
                make.top.equalTo(bottomView.snp.bottom)
                make.left.equalToSuperview()
                make.right.equalToSuperview()
            }
            flagLabel.text = "待补充"
            flagLabel.backgroundColor = UIColor(hex: 0xebf0f9)
        } else if dataSource.docStatus == 1003 {
            bottomLeftLineView.isHidden = true
            editButton.isHidden = false
            submitButton.isHidden = true
            lookButton.isHidden = true
            flagLabel.textColor = UIColor.brandMainColor
            if dataSource.docType == 1001 {
                flagLabel.text = "待签章"
                editButton.setTitle("查看", for: .normal)
            } else {
                flagLabel.text = "待签署"
                editButton.setTitle("签署", for: .normal)
            }
            flagLabel.backgroundColor = UIColor(hex: 0xebf0f9)
        } else if dataSource.docStatus == 1004 || dataSource.docStatus == 1006 || dataSource.docStatus == 1005 {
            bottomLeftLineView.isHidden = true
            editButton.isHidden = true
            submitButton.isHidden = false
            lookButton.isHidden = true
            submitButton.snp.remakeConstraints { make in
                make.bottom.equalToSuperview()
                make.top.equalTo(bottomView.snp.bottom)
                make.left.equalToSuperview()
                make.right.equalToSuperview()
            }
            flagLabel.textColor = UIColor(hex: 0xff8000)
            flagLabel.text = "审核中"
            flagLabel.backgroundColor = UIColor(hex: 0xfff5eb)

        } else if dataSource.docStatus == 1007 {
            bottomLeftLineView.isHidden = false
            editButton.isHidden = true
            submitButton.isHidden = false
            lookButton.isHidden = false
            submitButton.snp.remakeConstraints { make in
                make.bottom.equalToSuperview()
                make.top.equalTo(bottomView.snp.bottom)
                make.left.equalToSuperview()
                make.width.equalTo((KScreenWidth - 32)/2.0)
            }
            flagLabel.textColor = UIColor(hex: 0x3cc694)
            flagLabel.text = "已完成"
            flagLabel.backgroundColor = UIColor(hex: 0xf0fbf7)

        }
        
    }

    @objc func editButtonClick() {
        if dataSource?.docStatus == 1000 || dataSource?.docStatus == 1001 || dataSource?.docStatus == 1002 {
            if let block = block {
                block(.add)
            }
        } else {
            if dataSource?.docType == 1001 {
                if let block = block {
                    block(.look)
                }
            } else {
                if let block = block {
                    block(.sign)
                }
            }
        }
    }
    
    @objc func lookButtonClick() {
        if let block = block {
            block(.downLoad)
        }
    }
    
    @objc func submitButtonClick() {
        if let block = block {
            block(.look)
        }
    }
    
    @objc func shareButtonClick() {
        let title = "您的朋友邀请您点击小程序，协作签署" + (dataSource?.doc_type_name ?? "")
        YHShareManager.shared.shareToMiniProgram(path: miniPath, shareTitle: title)
    }
}
