//
//  YHGCWorkListHasDocTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHGCWorkListHasDocTableViewCell: UITableViewCell {
    typealias WorkExperienceBlock = (_ model: YHWorkExperienceModel) -> Void
    var workExperienceBlock: WorkExperienceBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var mainItemView: UIView!
    var workId: Int = 0
    var orderId: Int = 0
    var url: String = ""
    var companyList: [YHWorkItemListModel] = []
    var dataSource: YHSectionWorkExperienceModel? {
        didSet {
            updateAllViews()
        }
    }
    var selectDataSource: [ASAttributedString]?
    lazy var previewFileTool: YHFilePreviewTool = {
       let tool = YHFilePreviewTool(targetVC: UIViewController.current)
       return tool
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        centerView.addSubview(line)
        line.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        messageLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            let a: ASAttributedString = .init("备注：赴港同意书为目前在职公司盖章提供，若目前未就职于任何公司，则由档案所在地人才中心盖章提供，", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor(hex: 0x8893a2)))
            let b: ASAttributedString = .init("查看示例模板", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.brandMainColor), .underline(.single), .action {
                // 跳转模版
                self.previewFileTool.openXLSXRemoteFile(urlString: self.url, fileName: "")
            })
            label.attributed.text = a + b
            return label
        }()
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(68)
            make.right.equalTo(-18)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(132)
        }
    }
    
    func updateAllViews() {
        titleLabel.text = dataSource?.title
        mainItemView.removeSubviews()
        var y = 0
        for i in 0 ..< (dataSource?.models?.count ?? 0) {
            if y != 0 {
                let line = UIView()
                line.backgroundColor = UIColor.separatorColor
                mainItemView.addSubview(line)
                line.snp.makeConstraints { make in
                    make.left.equalTo(18)
                    make.top.equalTo(y)
                    make.height.equalTo(1)
                    make.right.equalTo(-18)
                }
            }
            y += 1
            let data = dataSource?.models?[i]
            let isShow = data?.isShowPrompts ?? false
            let message = data?.message ?? ""
            var h = 67
            if isShow && message.count == 0 {
                h += 20
            }
            let itemView = YHWorkExperienceItemView()
            itemView.companyList = companyList
            itemView.dataSource = data
            itemView.workId = workId
            itemView.orderId = orderId
            itemView.block = {[weak self] model in
                guard let self = self else { return }
                if let block = self.workExperienceBlock {
                    block(model)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(h)
                make.right.equalTo(-18)
            }
            y += h
        }
    }
}
