//
//  YHMyNewNameCardViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/9/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import AttributedString
import JXSegmentedView
import UIKit

class YHNameCardContainerViewController: YHBaseViewController {
    
    var userId: String = ""
    var userInfo: YHUserNameCardInfo? {
        didSet {
            dynamicVC.userInfo = userInfo
        }
    }

    var canScroll: Bool = false {
        didSet {
            homePageVC.vcCanScroll = canScroll
            dynamicVC.vcCanScroll = canScroll
        }
    }
    
    var defaultIndex: Int = 0 {
        didSet {
            self.segmentedView.selectItemAt(index: self.defaultIndex)
        }
    }
    
    let viewModel = YHMatchUserViewModel()

    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.titles = ["主页", "动态"]
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 14)
        dataSource.titleNormalColor = .brandGrayColor7
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 16)
        dataSource.titleSelectedColor = .brandGrayColor8
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = 32.0
        dataSource.itemSpacing = 24.0
        return dataSource
    }()

    // tab
    lazy var segmentedView: JXSegmentedView = {
        let view = JXSegmentedView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 48))
        view.backgroundColor = .white
        return view
    }()

    // 分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    lazy var childrenVC: [YHBaseViewController] = {
        let vcs: [YHBaseViewController] = [homePageVC, dynamicVC]
        return vcs
    }()
    
    lazy var homePageVC: YHNameCardHomePageViewController = {
        let vc = YHNameCardHomePageViewController()
        vc.userId = self.userId
        return vc
    }()
    
    lazy var dynamicVC: YHNameCardDynamicViewController = {
        let vc = YHNameCardDynamicViewController()
        vc.userId = self.userId
        return vc
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        createUI()
    }
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    func refreshData() {
        homePageVC.requestNameCardInfo()
        dynamicVC.requestList(true)
    }
    
    func requestNameCardInfo() {
        self.viewModel.getUserNameCardInfo(uid: self.userId) {
            _, _ in
        }
    }

    func createUI() {
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        segmentedView.listContainer = listContainerView
        // 配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16.0
        indicator.indicatorHeight = 2.0
        indicator.indicatorColor = UIColor.brandGrayColor8
        indicator.indicatorCornerRadius = 0
        indicator.verticalOffset = 4
        segmentedView.indicators = [indicator]
        segmentedView.defaultSelectedIndex = defaultIndex
        view.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(48)
        }
        view.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(segmentedView.snp.bottom).offset(0.0)
            make.height.equalTo(KScreenHeight-k_Height_NavigationtBarAndStatuBar-48-k_Height_safeAreaInsetsBottom()-46-10)
        }
    }
}

extension YHNameCardContainerViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        NotificationCenter.default.post(name: Notification.Name(rawValue: "scrollViewDidEndDragging0"), object: nil)
    }

    /// 正在滚动中的回调
    ///
    /// - Parameters:
    ///   - segmentedView: JXSegmentedView
    ///   - leftIndex: 正在滚动中，相对位置处于左边的index
    ///   - rightIndex: 正在滚动中，相对位置处于右边的index
    ///   - percent: 从左往右计算的百分比
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
        NotificationCenter.default.post(name: Notification.Name(rawValue: "scrollViewWillBeginDragging0"), object: nil)
    }
}

extension YHNameCardContainerViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        guard let vc = childrenVC[index] as? JXSegmentedListContainerViewListDelegate else {
            return YHNameCardHomePageViewController()
        }
        return vc
    }
}
