//
//  YHResignCertificateEvisaTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/9/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignCertificateEvisaTableViewCell: UITableViewCell {
    typealias ResignCertificateBlock = (_ model: YHResignCertificateModel) -> Void
    var clickBlock: ResignCertificateBlock?
    typealias ExperienceListBlock = (_ model: YHWorkExperienceFileModel, _ type: YHWorkFileClickType) -> Void
    var experienceListBlock: ExperienceListBlock?
    typealias NewFileBlock = () -> Void
    var newFileBlock: NewFileBlock?
    var dataModel: YHResignCertificateModel = YHResignCertificateModel()
    var isDisablEdit: Bool = false

    var centerView: UIView!
    var titleLabel: UILabel!
    var statusLabel: UILabel!
    var reasonLabel: UILabel!
    var lineView: UIView!
    var itemView: YHWorkFileItemView!
    var bottomView: YHWorkItemAddView!
    
    var dataSource: [YHWorkExperienceFileModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(16)
            make.bottom.equalToSuperview()
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "*卢华臣的电子签证"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        statusLabel = {
            let lable = UILabel(frame: CGRect(x: 0, y: 0, width: 38, height: 16))
            lable.text = "待上传"
            lable.font = .PFSC_M(ofSize: 10)
            lable.backgroundColor = UIColor(hex: 0x2F7EF6, transparency: 0.08)
            lable.textColor = .brandMainColor
            lable.layer.cornerRadius = kCornerRadius3
            lable.clipsToBounds = true
            lable.textAlignment = .center
            return lable
        }()
        centerView.addSubview(statusLabel)
        statusLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(8)
            make.centerY.equalTo(titleLabel.snp.centerY)
            make.height.equalTo(16)
            make.width.equalTo(38)
            make.right.lessThanOrEqualTo(-8)
        }

        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(0.5)
            make.top.equalTo(51.5)
        }
        
        reasonLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.failColor
            label.textAlignment = .left
            label.numberOfLines = 0
            label.text = "被驳回原因："
            return label
       }()
        centerView.addSubview(reasonLabel)
        reasonLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-20)
            make.top.equalTo(lineView.snp.bottom).offset(0)
            make.height.equalTo(0)
        }
        
        itemView = {
            let view = YHWorkFileItemView()
            view.block = {[weak self] model, type in
                guard let self = self else { return }
                if let block = self.experienceListBlock {
                    block(model, type)
                }
            }
            return view
        }()
        centerView.addSubview(itemView)
        itemView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(74)
            make.top.equalTo(reasonLabel.snp.bottom).offset(0)
            make.bottom.equalToSuperview()
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("上传".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.newFileBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
            make.top.equalTo(reasonLabel.snp.bottom).offset(0)
            make.bottom.equalTo(-16)
        }
    }
    
    func updateAllViews() {
        guard let model = dataSource, model.count != 0 else {
            bottomView.isHidden = false
            itemView.isHidden = true
            return
        }
        itemView.dataSource = model.first
        bottomView.isHidden = true
        itemView.isHidden = false
        
        reasonLabel.isHidden = (dataModel.status != ResignCertificateStatus.Rejected.rawValue)
        reasonLabel.text = "被驳回原因：" + dataModel.audit_remark
        reasonLabel.snp.remakeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            if dataModel.status != ResignCertificateStatus.Rejected.rawValue {
                make.height.equalTo(0)
            }
            make.top.equalTo(lineView.snp.bottom).offset(dataModel.status == ResignCertificateStatus.Rejected.rawValue ? 18 : 0)
        }
        
        isDisablEdit = dataModel.status == ResignCertificateStatus.Complete.rawValue
        itemView.editBtn.isHidden = isDisablEdit
        
        if dataModel.status == ResignCertificateStatus.NotUpload.rawValue {
            self.statusLabel.backgroundColor = UIColor.brandMainColor(alpha: 0.08)
            self.statusLabel.text = "待上传"
            self.statusLabel.textColor = UIColor.brandMainColor
            
        } else if dataModel.status == ResignCertificateStatus.Review.rawValue {
            self.statusLabel.backgroundColor = UIColor(hex: 0xFF8000).withAlphaComponent(0.08)
            self.statusLabel.text = "审核中"
            self.statusLabel.textColor = UIColor(hex: 0xFF8000)
            
        } else if dataModel.status == ResignCertificateStatus.Complete.rawValue {
            self.statusLabel.backgroundColor = UIColor(hex: 0x3CC694).withAlphaComponent(0.08)
            self.statusLabel.text = "已完成"
            self.statusLabel.textColor = UIColor(hex: 0x3CC694)
            
        } else if dataModel.status == ResignCertificateStatus.Rejected.rawValue {
            self.statusLabel.backgroundColor = UIColor(hex: 0xF81D22).withAlphaComponent(0.08)
            self.statusLabel.text = "已驳回"
            self.statusLabel.textColor = UIColor(hex: 0xF81D22)
        }
    }
}
