//
//  YHSheetSelectCell.swift
//  galaxy
//
//  Created by edy on 2024/1/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemSelectSheetCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemSelectSheetCell"
    let horizonalGap = 18.0

    private let titleColor = UIColor.mainTextColor
    private let detailColor = UIColor.mainTextColor
    private let placeHolderColor = UIColor.placeHolderColor
    // 是否必填 如必填title会展示红色*
    var isMust = false
    var placeHolder: String?
    var tipsBtnClickBlock: (() -> Void)?

    var title: String? {
        didSet {
            
            if let title = title, !title.isEmpty {
                let str = (isMust ? ("*"+title) : title)
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: UIFont.PFSC_R(ofSize: 14),
                    .foregroundColor: titleColor
                ]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                if isMust {
                    let starRange = NSRange(location: 0, length: 1)
                    questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                }
                titleLabel.attributedText = questionAttrStr
            } else {
                titleLabel.attributedText = nil
            }
        }
    }
    
    var detail: String? {
        didSet {

            if let detail = detail, !detail.isEmpty {
                detailLabel.text =  detail
                detailLabel.textColor = detailColor
            } else {
                detailLabel.text = isEmptyString(placeHolder) ? "请选择" : placeHolder
                detailLabel.textColor = placeHolderColor
            }
        }
    }
    
    // 是否隐藏顶部分割线
    var isHiddenTopLine: Bool = false {
        didSet {
            topLine.isHidden = isHiddenTopLine
        }
    }
    
    // 是否展示标题旁的提示!按钮
    var isShowTipsButton: Bool = false {
        didSet {
            tipsButton.isHidden = !isShowTipsButton
        }
    }

    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = titleColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = detailColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 14)
        return label
    }()
    
    lazy var tipsButton: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "form_btn_tips"), for: .normal)
        btn.addTarget(self, action: #selector(didTipsButtonClicked), for: .touchUpInside)
        btn.isHidden = true
        return btn
    }()
    
    private lazy var arrowImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imgView
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.isHidden = true
        return label
    }()
    
    private lazy var topLine: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(titleLabel)
        contentView.addSubview(detailLabel)
        contentView.addSubview(arrowImgView)
        contentView.addSubview(tipsLabel)
        contentView.addSubview(topLine)
        contentView.addSubview(tipsButton)

        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(horizonalGap)
            make.width.lessThanOrEqualTo(120)
        }
        
        tipsButton.snp.makeConstraints { make in
            make.centerY.equalTo(titleLabel)
            make.left.equalTo(titleLabel.snp.right).offset(0)
            make.width.height.equalTo(16.0)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel)
            make.left.equalToSuperview().offset(horizonalGap+120+8)
            make.right.equalTo(arrowImgView.snp.left)
        }
        
        arrowImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 20, height: 20))
            make.right.equalToSuperview().offset(-horizonalGap)
            make.top.equalTo(titleLabel)
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
        
        setTips("", isShow: false)
        tipsButton.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)

    }
    
    @objc func didTipsButtonClicked() {
        if let tipsBtnClickBlock = tipsBtnClickBlock {
            tipsBtnClickBlock()
        }
    }
    
    func setTips(_ tips: String?, isShow: Bool) {
        tipsLabel.text = tips
        tipsLabel.isHidden = !isShow
        if isShow {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(detailLabel.snp.bottom).offset(6)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(detailLabel.snp.bottom)
                make.height.equalTo(0)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
}
