//
//  YHLifeSectionView.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHLifeSectionView: UIView {

    static let viewH: CGFloat = 44.0

    typealias Block = (Int) -> Void
    var block: Block?
    
    var items: [String] = [] {
        didSet {
            self.myCollectView.reloadData()
        }
    }
   
    var type: Int = 0
    
    var selectIndex = 0 {
        didSet {
            self.myCollectView.reloadData()
        }
    }
    
    lazy var myCollectView = {
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.itemSize = CGSize(width: 50, height: 26)
        flowLayout.minimumInteritemSpacing = 12.0
        flowLayout.minimumLineSpacing = 12.0
        flowLayout.scrollDirection = .horizontal
        
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .white
        collectinoView.contentInset = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 20)
        collectinoView.register(YHLifeSectionCollectionViewCell.self, forCellWithReuseIdentifier: YHLifeSectionCollectionViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        collectinoView.bounces = false
        collectinoView.showsHorizontalScrollIndicator = false
        collectinoView.showsVerticalScrollIndicator = false
        return collectinoView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        backgroundColor = .white
        addSubview(myCollectView)
        myCollectView.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
//        self.myCollectView.es.addInfiniteScrolling {
//            self.loadFakeData()
//        }
    }
    
}

extension YHLifeSectionView: UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return items.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHLifeSectionCollectionViewCell.cellReuseIdentifier, for: indexPath) as? YHLifeSectionCollectionViewCell else {
            return UICollectionViewCell()
        }
        cell.dataSource = items[indexPath.row]
        
        if indexPath.row == selectIndex {
            cell.setSelectedStyle()
        } else {
            cell.setDeSelectedStyle()
        }
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        selectIndex = indexPath.row
        collectionView.reloadData()
        if let block = block {
            block(indexPath.row)
        }
        print("index is \(indexPath.row)")
    }
}

class YHLifeSectionCollectionViewCell: UICollectionViewCell {
    static let cellReuseIdentifier = "YHLifeSectionCollectionViewCell"
 
    func setSelectedStyle() {
        descripeLable.textColor = UIColor.mainTextColor
        contentView.layer.borderWidth = 1
        contentView.layer.borderColor = UIColor.mainTextColor.cgColor
    }
 
    func setDeSelectedStyle() {
        descripeLable.textColor = UIColor.mainTextColor50
        contentView.layer.borderWidth = 1
        contentView.layer.borderColor = UIColor.mainTextColor18.cgColor
    }
    
    var dataSource: String? {
        didSet {
            updataAllSubViews()
        }
    }
    
    lazy var descripeLable: UILabel = {
        let label = UILabel()
        label.text = "赴港"
        label.textColor = UIColor(hex: 0x94a3bb)
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textAlignment = .center
        return label
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    private func setupUI() {
        contentView.addSubview(descripeLable)
        descripeLable.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
    }
    
    func updataAllSubViews() {
        guard let dataSource = dataSource else { return }
        descripeLable.text = dataSource
    }
    
}
