//
//  YHCustomNavigationBar.swift
//  galaxy
//
//  Created by edy on 2024/3/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHNavLeftSecondBtnType: Int {
    case none = 0
    case search = 1
}

enum YHNavRightBtnType: Int {
    case none = 0
    case clean = 1
}

class YHCustomNavigationBar: UIView {
    
    static let searchLeftIcon = ""
    
    var title: String? {
        didSet {
            titleLabel.text = title
        }
    }
    var titleColor: UIColor? {
        didSet {
            titleLabel.textColor = titleColor
        }
    }
    var backBlock: (() -> Void)?
    var leftSecondBtnClick: (() -> Void)?
    var rightBtnClick: (() -> Void)?
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .navTitleColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        return label
    }()
    
    lazy var backButton: UIButton = {
       let btn = UIButton()
        btn.setImage(UIImage(named: "back_icon"), for: .normal)
        btn.addTarget(self, action: #selector(didBackBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    private lazy var leftSecondButton: UIButton = {
       let btn = UIButton()
        btn.addTarget(self, action: #selector(didleftSecondButtonClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var rightButton: UIButton = {
        let btn = UIButton()
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        btn.addTarget(self, action: #selector(didRightButtonClicked), for: .touchUpInside)
        return btn
    }()
   
    static func navBar() -> YHCustomNavigationBar {
        let bar = YHCustomNavigationBar(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: k_Height_NavContentBar))
        return bar
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func showLeftSecondButtonType(_ type: YHNavLeftSecondBtnType) {
        if type == .search {
            leftSecondButton.setImage(UIImage(named: "nav_search_icon"), for: .normal)
        }
    }
    
    func showRightButtonType(_ type: YHNavRightBtnType) {
        if type == .clean {
            rightButton.setImage(UIImage(named: "msg_clean"), for: .normal)
        }
    }
    
    func createUI() {
        self.addSubview(titleLabel)
        self.addSubview(backButton)
        self.addSubview(leftSecondButton)
        self.addSubview(rightButton)
        
        titleLabel.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        backButton.snp.makeConstraints { make in
            make.width.height.equalTo(30)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(12)
        }
        
        leftSecondButton.snp.makeConstraints { make in
            make.width.height.equalTo(30)
            make.centerY.equalToSuperview()
            make.left.equalTo(backButton.snp.right).offset(5)
        }
        
        rightButton.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-20)
        }
    }
}

extension YHCustomNavigationBar {
    @objc func didBackBtnClicked() {
        if let backBlock = backBlock {
            backBlock()
        }
    }
    
    @objc func didleftSecondButtonClicked() {
        if let leftSecondBtnClick = leftSecondBtnClick {
            leftSecondBtnClick()
        }
    }
    
    @objc func didRightButtonClicked() {
        if let rightBtnClick = rightBtnClick {
            rightBtnClick()
        }
    }
}
