//
//  YHNameCardHomePageViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/9/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHNameCardHomePageViewController: YHBaseViewController {
    
    var userId: String = ""
    var cardInfoArr: [YHUserNameCardInfo] = []
    let viewModel = YHMatchUserViewModel()
    
    var vcCanScroll: Bool = false {
        didSet {
            tableView.isScrollEnabled = vcCanScroll
        }
    }
    
    var isCurrentUser: Bool {
        get {
           return (!self.userId.isEmpty && self.userId == YHLoginManager.shared.userModel?.id)
        }
    }
    
    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .grouped)
        tableView.estimatedSectionHeaderHeight = 100
        tableView.showsVerticalScrollIndicator = false
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.backgroundColor = .clear
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHMyNameCardAvatarInfoCell.self, forCellReuseIdentifier: YHMyNameCardAvatarInfoCell.cellReuseIdentifier)
        tableView.register(YHMyIntroductionCell.self, forCellReuseIdentifier: YHMyIntroductionCell.cellReuseIdentifier)
        tableView.register(YHMyEducationCell.self, forCellReuseIdentifier: YHMyEducationCell.cellReuseIdentifier)
        tableView.register(YHMyWorkExperienceCell.self, forCellReuseIdentifier: YHMyWorkExperienceCell.cellReuseIdentifier)
        tableView.register(YHMyInterestTopicCell.self, forCellReuseIdentifier: YHMyInterestTopicCell.cellReuseIdentifier)
        return tableView
    }()
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        gk_navigationBar.isHidden = true
        createUI()
        requestNameCardInfo()
    }
    
    func createUI() {
        vcCanScroll = false
        view.addSubview(self.tableView)
        self.tableView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalToSuperview()
            make.top.equalToSuperview()
        }
    }
    
    func requestNameCardInfo() {
        self.viewModel.getUserNameCardInfo(uid: self.userId) {
            _, _ in
            
            self.cardInfoArr.removeAll()
            
            // 个人简介信息
            var isShowIntroduce = true
            if !self.isCurrentUser {
                isShowIntroduce = !self.viewModel.nameCardInfo.bio.isEmpty
            }
            if isShowIntroduce {
                let model2 = YHUserNameCardInfo()
                model2.type = .introduce
                model2.isCurrentUser = self.isCurrentUser
                model2.updateModel(self.viewModel.nameCardInfo)
                self.cardInfoArr.append(model2)
            }
           
            // 教育经历信息
            var isShowEducation = true
            if !self.isCurrentUser {
                isShowEducation = !self.viewModel.nameCardInfo.isHiddenEducation
                if isShowEducation {
                    isShowEducation = (!self.viewModel.nameCardInfo.college.isEmpty || !self.viewModel.nameCardInfo.background.isEmpty || !self.viewModel.nameCardInfo.major.isEmpty)
                }
            }
            if isShowEducation {
                let model3 = YHUserNameCardInfo()
                model3.type = .education
                model3.isCurrentUser = self.isCurrentUser
                model3.updateModel(self.viewModel.nameCardInfo)
                self.cardInfoArr.append(model3)
            }
            
            // 工作经历信息
            var isShowWorkExperience = true
            if !self.isCurrentUser {
                isShowWorkExperience = !self.viewModel.nameCardInfo.isHiddenWorkExperience
                if isShowWorkExperience {
                    isShowWorkExperience = (!self.viewModel.nameCardInfo.companyName.isEmpty || !self.viewModel.nameCardInfo.position.isEmpty || !self.viewModel.nameCardInfo.industry.isEmpty)
                }
            }
            if isShowWorkExperience {
                let model4 = YHUserNameCardInfo()
                model4.type = .workExperience
                model4.isCurrentUser = self.isCurrentUser
                model4.updateModel(self.viewModel.nameCardInfo)
                self.cardInfoArr.append(model4)
            }
            
            // 荣誉奖项信息
            var isShowHonor = true
            if !self.isCurrentUser {
                isShowHonor = !self.viewModel.nameCardInfo.honor.isEmpty
            }
            if isShowHonor {
                let model5 = YHUserNameCardInfo()
                model5.type = .honor
                model5.isCurrentUser = self.isCurrentUser
                model5.updateModel(self.viewModel.nameCardInfo)
                self.cardInfoArr.append(model5)
            }
            
            // 兴趣话题
            var isShowTopics = true
            if !self.isCurrentUser {
                isShowTopics = self.viewModel.nameCardInfo.topics.count > 0
            }
            if isShowTopics {
                let model6 = YHUserNameCardInfo()
                model6.type = .topics
                model6.isCurrentUser = self.isCurrentUser
                model6.updateModel(self.viewModel.nameCardInfo)
                self.cardInfoArr.append(model6)
            }
            self.tableView.reloadData()
        }
    }
}

extension YHNameCardHomePageViewController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return self.cardInfoArr.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if 0 <= indexPath.section && indexPath.section < self.cardInfoArr.count {
            let cardInfo = self.cardInfoArr[indexPath.section]
            
            if cardInfo.type == .honor || cardInfo.type == .introduce {
                
                guard let introCell = tableView.dequeueReusableCell(withIdentifier: YHMyIntroductionCell.cellReuseIdentifier, for: indexPath) as? YHMyIntroductionCell else { return UITableViewCell() }
                introCell.userModel = cardInfo
                introCell.editBlock = { [weak self] in
                    guard let self = self else { return }
                    if cardInfo.type == .honor {
                        let vc = YHEditHonorViewController()
                        vc.model = self.viewModel.nameCardInfo
                        self.navigationController?.pushViewController(vc)
                    } else if cardInfo.type == .introduce {
                        let vc = YHEditPersonalProfileViewController()
                        vc.model = self.viewModel.nameCardInfo
                        self.navigationController?.pushViewController(vc)
                    }
                }
                return introCell
            }
            
            if cardInfo.type == .education {
                guard let eduCell = tableView.dequeueReusableCell(withIdentifier: YHMyEducationCell.cellReuseIdentifier, for: indexPath) as? YHMyEducationCell else { return UITableViewCell() }
                eduCell.userModel = cardInfo
                eduCell.hiddenBtnBlock = {
                    [weak self] in
                    guard let self = self else { return }
                    YHWholeScreenTipsView.show(type: .nameCardEducation, targetView: eduCell.hiddenBtn)
                }
                eduCell.editBlock = { [weak self] in
                    guard let self = self else { return }
                    let vc = YHEditSchoolViewController()
                    vc.model = self.viewModel.nameCardInfo
                    self.navigationController?.pushViewController(vc)
                }
                return eduCell
            }
            
            if cardInfo.type == .workExperience {
                guard let workCell = tableView.dequeueReusableCell(withIdentifier: YHMyWorkExperienceCell.cellReuseIdentifier, for: indexPath) as? YHMyWorkExperienceCell else { return UITableViewCell() }
                workCell.userModel = cardInfo
                workCell.hiddenBtnBlock = {
                    [weak self] in
                    guard let self = self else { return }
                    YHWholeScreenTipsView.show(type: .nameCardWorkExperience, targetView: workCell.hiddenBtn)
                }
                workCell.editBlock = { [weak self] in
                    guard let self = self else { return }
                    let vc = YHEditWorkViewController()
                    vc.model = self.viewModel.nameCardInfo
                    self.navigationController?.pushViewController(vc)
                }
                return workCell
            }
            
            if cardInfo.type == .topics {
                guard let topicCell = tableView.dequeueReusableCell(withIdentifier: YHMyInterestTopicCell.cellReuseIdentifier, for: indexPath) as? YHMyInterestTopicCell else { return UITableViewCell() }
                topicCell.userModel = cardInfo
                topicCell.editBlock = { [weak self] in
                    guard let self = self else { return }
                    let vc = YHEditInterestViewController()
                    vc.model = self.viewModel.nameCardInfo
                    self.navigationController?.pushViewController(vc)
                }
                return topicCell
            }
        }
        
        let defaultCell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return defaultCell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 16.0
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        let view = UIView()
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 1.0
    }
}

extension YHNameCardHomePageViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}

extension YHNameCardHomePageViewController: UIScrollViewDelegate {
    // 控制滑动交互
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        let scrollViewSet: CGFloat = scrollView.contentOffset.y
        if vcCanScroll == false {// 不能滚动时
            scrollView.contentOffset = CGPoint(x: 0, y: 0)
        } else {
            if scrollViewSet <= 0 {
                scrollView.contentOffset = CGPoint(x: 0, y: 0)
                vcCanScroll = false
                NotificationCenter.default.post(name: Notification.Name(rawValue: "leaveTop0"), object: nil)
            } else {
                scrollView.contentOffset = CGPoint(x: 0, y: scrollViewSet)
            }
        }
    }
}
