//
//  YHMemberCenterMyPrivilegeCell.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/18.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMemberCenterMyPrivilegeCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHMemberCenterMyPrivilegeCell"

    private lazy var leftIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "member_coin")
        return view
    }()

    private lazy var midLabel: UILabel = {
        let label = UILabel()
        label.text = "我的xx会员特权"
        label.textColor = UIColor.mainTextColor
        label.font = .PFSC_M(ofSize: 16)
        return label
    }()

    private lazy var rightLabel: UILabel = {
        let label = UILabel()
        label.text = "5项"
        label.textColor = UIColor.mainTextColor
        label.font = .PFSC_R(ofSize: 14)
        return label
    }()

    private lazy var rightIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "right_arrow_black_20")
        return view
    }()
    
    private lazy var bottomContainerView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#F8F9FB")
        view.layer.cornerRadius = 2
        view.clipsToBounds = true
        return view
    }()
    
    private lazy var privilegeLabel: UILabel = {
        let label = UILabel()
        label.text = "高端权益兑换"
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var privilegeTipsLabel: UILabel = {
        let label = UILabel()
        label.text = "可兑换次数: 0，已兑换次数: 0"
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = UIColor(hexString: "#8993A2")
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCell(mid: String, right: String, redeemCount: Int, redeemedCount: Int, needShowBottom: Bool) {
        midLabel.text = mid
        rightLabel.text = right
        bottomContainerView.isHidden = !needShowBottom
        if needShowBottom {
            privilegeLabel.text = "高端权益兑换"
            privilegeTipsLabel.text = "可兑换次数: \(redeemCount)，已兑换次数: \(redeemedCount)"
            bottomContainerView.snp.remakeConstraints { make in
                make.top.equalTo(midLabel.snp.bottom).offset(17)
                make.left.equalTo(leftIcon)
                make.right.equalTo(rightIcon)
                make.bottom.equalToSuperview().offset(-17)
                make.height.equalTo(41)
            }
        } else {
            privilegeLabel.text = nil
            privilegeTipsLabel.text = nil
            bottomContainerView.snp.remakeConstraints { make in
                make.top.equalTo(midLabel.snp.bottom)
                make.left.equalTo(leftIcon)
                make.right.equalTo(rightIcon)
                make.bottom.equalToSuperview().offset(-17)
                make.height.equalTo(0)
            }
        }
    }

    private func setupUI() {
        subContainerView.radius = 4
        updateCellCorner(.single)
        subContainerView.addSubview(midLabel)
        subContainerView.addSubview(leftIcon)
        subContainerView.addSubview(rightLabel)
        subContainerView.addSubview(rightIcon)
        
        subContainerView.addSubview(bottomContainerView)
        bottomContainerView.addSubview(privilegeLabel)
        bottomContainerView.addSubview(privilegeTipsLabel)

        midLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        leftIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightLabel.setContentCompressionResistancePriority(.required, for: .horizontal)

        leftIcon.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.left.equalToSuperview().offset(16)
            make.width.height.equalTo(24)
        }

        midLabel.snp.makeConstraints { make in
            make.centerY.equalTo(leftIcon)
            make.left.equalTo(leftIcon.snp.right).offset(8)
            make.right.lessThanOrEqualTo(rightLabel.snp.left).offset(-8)
        }

        rightIcon.snp.makeConstraints { make in
            make.centerY.equalTo(leftIcon)
            make.right.equalToSuperview().offset(-16)
            make.width.height.equalTo(20)
        }

        rightLabel.snp.makeConstraints { make in
            make.centerY.equalTo(leftIcon)
            make.right.equalTo(rightIcon.snp.left).offset(-1)
        }
        
        bottomContainerView.snp.makeConstraints { make in
            make.top.equalTo(midLabel.snp.bottom).offset(17)
            make.left.equalTo(leftIcon)
            make.right.equalTo(rightIcon)
            make.bottom.equalToSuperview().offset(-17)
            make.height.equalTo(41)
        }
        privilegeLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        privilegeTipsLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        privilegeLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(12)
            make.centerY.equalToSuperview()
        }
        
        privilegeTipsLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-12)
            make.centerY.equalToSuperview()
        }
    }
}
