//
//  YHSelectLookView.swift
//  galaxy
//
//  Created by EDY on 2024/11/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Lottie

class YHSelectLookView: UIView {
    static let viewH: CGFloat = 92.0
    
    var items: [YHLiveModel] = [] {
        didSet {
            self.myCollectView.reloadData()
        }
    }
   
    var type: Int = 0
    
    var selectIndex = 0 {
        didSet {
            self.myCollectView.reloadData()
        }
    }
    
    lazy var myCollectView = {
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.itemSize = CGSize(width: 60, height: 76)
        flowLayout.minimumInteritemSpacing = 12.0
        flowLayout.minimumLineSpacing = 12.0
        flowLayout.scrollDirection = .horizontal
        
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .contentBkgColor
        collectinoView.contentInset = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 20)
        collectinoView.register(YHSelectLookViewCell.self, forCellWithReuseIdentifier: YHSelectLookViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        collectinoView.bounces = false
        collectinoView.showsHorizontalScrollIndicator = false
        collectinoView.showsVerticalScrollIndicator = false
        return collectinoView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        backgroundColor = .white
        addSubview(myCollectView)
        myCollectView.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
//        self.myCollectView.es.addInfiniteScrolling {
//            self.loadFakeData()
//        }
    }
    
    func checkLogin() -> Bool {
        if YHLoginManager.shared.isLogin() == false {
            YHOneKeyLoginManager.shared.oneKeyLogin()
            return false
        }
        return true
    }
    
}

extension YHSelectLookView: UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if items.count < 7 {
            return items.count
        } else {
            return 6
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHSelectLookViewCell.cellReuseIdentifier, for: indexPath) as? YHSelectLookViewCell else { return UICollectionViewCell() }
        if indexPath.row < 5 {
            cell.dataSource = items[indexPath.row]
        } else {
            cell.moreState()
        }
        
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        // 跳转直播 文哥代办
        if indexPath.row == 5 {
            NotificationCenter.default.post(name: YhConstant.YhNotification.backToHomeNotification, object: nil, userInfo: ["value": 2])
            return
        }
        
        guard items.count > indexPath.row else {
            return
        }
        if !checkLogin() {
            return
        }
        YHAnalytics.track("APP_GalaxySelectionPage_LiveAvatar")
        let item = items[indexPath.row]
        let playbackInfo = YHPlayerManager.PlaybackInfo(id: item.id, url: nil, title: item.live_title, roomId: item.room_id.count > 0 ? item.room_id : nil, uid: nil, isLive: true, scene: .fullscreen)
        YHPlayerManager.shared.enterLive(from: nil, playbackInfo: playbackInfo)
    }
}

class YHSelectLookViewCell: UICollectionViewCell {
    static let cellReuseIdentifier = "YHSelectLookViewCell"
    var animationView: LottieAnimationView!
    var liveAnimationView: LottieAnimationView!

    lazy var headIamge: UIImageView = {
        let image = UIImageView()
        image.image = UIImage(named: "home_look_head")
        image.layer.cornerRadius = 24
        image.layer.masksToBounds = true
        image.layer.borderWidth = 2
        image.layer.borderColor = UIColor.brandMainColor.cgColor
        return image
    }()
    
    var dataSource: YHLiveModel? {
        didSet {
            updataAllSubViews()
        }
    }
    
    lazy var descripeLable: UILabel = {
        let label = UILabel()
        label.text = "更多直播"
        label.textColor = UIColor(hex: 0x6d788a)
        label.font = UIFont.PFSC_R(ofSize: 11)
        label.textAlignment = .center
        return label
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    private func setupUI() {
        animationView = {
            let view = LottieAnimationView(name: "zhibo")
            view.loopMode = .loop
            return view
        }()
        contentView.addSubview(animationView)
        animationView.snp.makeConstraints { make in
            make.top.centerX.equalToSuperview()
            make.width.height.equalTo(54)
        }
        
        contentView.addSubview(headIamge)
        headIamge.snp.makeConstraints { make in
            make.center.equalTo(animationView.snp.center)
            make.width.height.equalTo(48)
        }
        
        liveAnimationView = {
            let view = LottieAnimationView(name: "live")
            view.backgroundColor = UIColor.brandMainColor
            view.loopMode = .loop
            return view
        }()
        contentView.addSubview(liveAnimationView)
        liveAnimationView.snp.makeConstraints { make in
            make.bottom.equalTo(animationView.snp.bottom).offset(-3)
            make.right.equalTo(animationView.snp.right).offset(-3)
            make.width.height.equalTo(14)
        }
        
        contentView.addSubview(descripeLable)
        descripeLable.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(14)
        }
        animationView.play()
        liveAnimationView.play()
        
    }
    
    func updataAllSubViews() {
        guard let dataSource = dataSource else { return }
        descripeLable.text = dataSource.account
        headIamge.kf.setImage(with: URL(string: dataSource.avatar))
        animationView.isHidden = false
        liveAnimationView.isHidden = false
        headIamge.layer.borderWidth = 2
    }
    
    func moreState() {
        headIamge.image = UIImage(named: "home_live_more")
        animationView.isHidden = true
        liveAnimationView.isHidden = true
        headIamge.layer.borderWidth = 0

    }
}
