//
//  YHHKRecordsExpandedCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsExpandedCell: UITableViewCell {

    static let cellReuseIdentifier = "YHHKRecordsExpandedCell"
    
    var isExpanded: Bool = true {
        didSet {
            infoDetailLabel.text = isExpanded ? "收起" : "详情"
        }
    }
    
    private lazy var subContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 8, corner: .none)
        view.backgroundColor = .white
        return view
    }()
    
    private lazy var tagView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 16)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var statusLabel: YHPaddedLabel = {
        let label = YHPaddedLabel(padding: UIEdgeInsets(top: 0, left: 6, bottom: 0, right: 6))
        label.font = .PFSC_M(ofSize: 12)
        label.layer.cornerRadius = 2
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .brandMainColor
        label.font = .PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.isHidden = true
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, status: YHHKNonPresenceRecordType, isExpanded: Bool, isShowBottomLine: Bool = false, isBottom: Bool = false) {
        infoTitleLabel.text = title
        if status == .normal {
            statusLabel.isHidden = true
            statusLabel.text = nil
            statusLabel.textColor = nil
            statusLabel.backgroundColor = nil
        } else {
            statusLabel.isHidden = false
            statusLabel.text = status.title
            statusLabel.textColor = status.titleColor
            statusLabel.backgroundColor = status.bgColor
        }
        
        self.isExpanded = isExpanded
        bottomLineView.isHidden = !isShowBottomLine
        subContainerView.corner = isBottom ? [.bottomLeft, .bottomRight] : .none
    }

}

extension YHHKRecordsExpandedCell {
    
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(subContainerView)
        subContainerView.addSubview(tagView)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(statusLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(bottomLineView)
        tagView.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        statusLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        subContainerView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
        
        tagView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.centerY.equalToSuperview()
            make.width.equalTo(3)
            make.height.equalTo(14)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(tagView.snp.right).offset(5)
            make.centerY.equalToSuperview()
        }
        
        statusLabel.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.right).offset(4)
            make.centerY.equalToSuperview()
            make.height.equalTo(19)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(statusLabel.snp.right).offset(4)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-18)
        }
    }
}

private extension YHHKNonPresenceRecordType {
    var titleColor: UIColor? {
        switch self {
        case .over90:
            return UIColor.yhOrangeColor
        case .over180:
            return UIColor.failColor
        case .normal:
            return nil
        }
    }
    
    var bgColor: UIColor? {
        switch self {
        case .normal:
            return nil
        case .over90:
            return UIColor(hexString: "#FFF5EB")
        case .over180:
            return UIColor(hexString: "#FFF2F2")
        }
    }
}
