//
//  YHOtherInfoFillViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOtherInfoFillViewModel: YHBaseViewModel {
    var otherInfoFillData: YHOtherInfoFillModel?
    
    /*
     //语言枚举
       const LANGUAGE_DETAIL = [
           "data" => [
               [
                   "id"                 => 1,
                   'name'               => "中文",
                   "select"             => 0,
                   "other_instructions" => "",
                   'child'              => [
                       ['id' => 99, "name" => "均不能提供", "select" => 0,],
                       ['id' => 1, "name" => "母语（不用任何证明）", "select" => 0,],
                       ['id' => 2, "name" => "《普通话水平测试》取得及格或以上成绩的证书", "select" => 0,],
                       ['id' => 3, "name" => "《中国汉语水平考试》取得第三级或以上成绩的证书", "select" => 0,],
                       ['id' => 4, "name" => "其他证件（仅尝试加分）", "select" => 0,],
                   ],
               ],
               [
                   "id"                 => 2,
                   'name'               => "英文",
                   "select"             => 0,
                   "other_instructions" => "",
                   'child'              => [
                       ['id' => 99, "name" => "均不能提供", "select" => 0,],
                       ['id' => 1, "name" => "母语（不用任何证明）", "select" => 0,],
                       ['id' => 2, "name" => "雅思(IELTS)考试取得7.0或以上成绩的成绩单", "select" => 0,],
                       ['id' => 3, "name" => "托福(TOEFL)网上考试取得94分或以上成绩的成绩单", "select" => 0,],
                       ['id' => 4, "name" => "全国大学英语六级考试(CET-6)取得520分或以上成绩的证书", "select" => 0,],
                       ['id' => 5, "name" => "英语授课证明", "select" => 0,],
                       ['id' => 6, "name" => "英语国家授予的学位证及成绩单", "select" => 0,],
                       ['id' => 7, "name" => "英语相关专业学位证 、 毕业证、 学位认证报告", "select" => 0,],
                       ['id' => 8, "name" => "其他证件（仅尝试加分）", "select" => 0,],
                   ],
               ],
               [
                   "id"                 => 3,
                   'name'               => "其他",
                   "select"             => 0,
                   "other_instructions" => "",
                   'child'              => [
                       ['id' => 99, "name" => "均不能提供", "select" => 0,],
                       ['id' => 1, "name" => "母语", "select" => 0,],
                       ['id' => 2, "name" => "授课语言证明]", "select" => 0,],
                       ['id' => 3, "name" => "相关语言国家授予的学位证及成绩单", "select" => 0,],
                       ['id' => 4, "name" => "该语言相关专业学位证 、 毕业证、 学位认证报告", "select" => 0,],
                       ['id' => 5, "name" => "官方语言成绩单", "select" => 0,],
                   ],
               ],
           ],
       ];
     */
    
    static let languageJsonData: [[String: Any]] = [
        ["id": 1,
         "name": "中文",
         "select": 0,
         "other_instructions": "",
         "options": [
            ["id": 1,
             "name": "母语（不用任何证明）",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 2,
             "name": "《普通话水平测试》取得及格或以上成绩的证书",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 3,
             "name": "《中国汉语水平考试》取得第三级或以上成绩的证书",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 4,
             "name": "其他证明",
             "select": 0,
             "subname": "(仅可尝试加分，此类文件加分以港府审批为准)",
             "highlight": ""],
            
            ["id": 99,
             "name": "以上均不能提供",
             "select": 0,
             "subname": "(或将导致您的该语言能力不被认可，请尽可能准备以上材料并修改此选项)",
             "highlight": "不被认可"]
         ]
        ],
        
        ["id": 2,
         "name": "英文",
         "select": 0,
         "other_instructions": "",
         "options": [
            ["id": 1,
             "name": "母语（不用任何证明）",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 2,
             "name": "雅思(IELTS)考试取得7.0或以上成绩的成绩单",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 3,
             "name": "托福(TOEFL)网上考试取得94分或以上成绩的成绩单",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 4,
             "name": "全国大学英语六级考试(CET-6)取得520分或以上成绩的证书",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 5,
             "name": "英语授课证明",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 6,
             "name": "英语国家授予的学位证及成绩单",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 7,
             "name": "英语相关专业学位证 、 毕业证、 学位认证报告",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 8,
             "name": "其他证明",
             "select": 0,
             "subname": "（仅可尝试加分，此类文件加分以港府审批为准）",
             "highlight": ""],
            
            ["id": 99,
             "name": "以上均不能提供",
             "select": 0,
             "subname": "(或将导致您的该语言能力不被认可，请尽可能准备以上材料并修改此选项)",
             "highlight": "不被认可"]
         ]
        ],
        
        ["id": 3,
         "name": "其他",
         "select": 0,
         "other_instructions": "",
         "options": [
            ["id": 1,
             "name": "母语",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 2,
             "name": "授课语言证明",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 3,
             "name": "相关语言国家授予的学位证及成绩单",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 4,
             "name": "该语言相关专业学位证 、 毕业证、 学位认证报告",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 5,
             "name": "官方语言成绩单",
             "select": 0,
             "subname": "",
             "highlight": ""],
            
            ["id": 6,
             "name": "其他证明",
             "select": 0,
             "subname": "（仅可尝试加分，此类文件加分以港府审批为准）",
             "highlight": ""],
            
            ["id": 99,
             "name": "以上均不能提供",
             "select": 0,
             "subname": "(或将导致您的该语言能力不被认可，请尽可能准备以上材料并修改此选项)",
             "highlight": "不被认可"]
         ]
        ]
    ]
    
}

extension YHOtherInfoFillViewModel {
    
    // 获取其他资料信息
    func getOtherInfo( params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.otherInfoFillApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHOtherInfoFillModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                
//                if resultModel.residences.isEmpty {
//                    resultModel.residences.append(Residence())
//                }
                
                self.otherInfoFillData = resultModel
                
                // 根据返回值 组装 真实的数据
                handleData()
                
                callBackBlock(true, nil)
                
            } else {
                let err: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 保存其他资料信息
    func saveOtherInfo( params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.updateOtherInfoApi
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            printLog("model 是 ==> \(json)")
            // 根据返回值 组装 真实的数据
            
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
            
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
}

extension YHOtherInfoFillViewModel {
    func handleData() {
//        if let language = self.otherInfoFillData?.language_detail {
//            if language.level > 0 {
//                let target = String(language.level)
//                for(_,item) in YHConstantArrayData.arrLanguage.enumerated() {
//                    
//                    if target == item["id"] {
//                        language.levelDes = item["title"] ?? ""
//                        break
//                    }
//                }
//            }
//        }
        
        // 语言 根据 返回值 进行数据结构
        if let arr = [LanguageDetailModel].deserialize(from: YHOtherInfoFillViewModel.languageJsonData) {
            if let arrT = self.otherInfoFillData?.language_detail_new, arrT.count > 0 {
                for (index, item) in arrT.enumerated() {
                    for (ii, tt) in arr.enumerated() {
                        if item.first_select == tt.id {
                            tt.select = true
                            tt.other_instructions = item.other_instructions
                            
                            let arrTTT = item.second_select.split(separator: ",")
                            if arrTTT.count > 0 {
                                let tmpId: Int = Int(arrTTT[0]) ?? 0
                                for (_, ttt) in tt.options.enumerated() {
                                    if tmpId == ttt.id {
                                        ttt.select = true
                                    }
                                }
                            }
                        }
                    }
                }
            }
            self.otherInfoFillData?.language_detail_new_data = arr
        } else {
            self.otherInfoFillData?.language_detail_new_data = []
        }
        
        if let profession = self.otherInfoFillData?.profession {
            if profession.option > 0 {
                let target = String(profession.option)
                for(_, item) in YHConstantArrayData.arrSkill.enumerated() {
                    
                    if target == item["value"] {
                        profession.optionDes = item["title"] ?? ""
                        break
                    }
                }
            }
        }
    }
}
