//
//  YHPreviewInfoIncomeTypeCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoIncomeTypeCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHPreviewInfoIncomeTypeCell"
    private var documentationViews: [YHIncomeDocumentationView] = []
    private var lastDocuments: [String] = []

    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor(hexString: "#8993A2")
        return label
    }()
    
    private lazy var containerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 3, corner: .allCorners)
        view.backgroundColor = .contentBkgColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, documents: [String]) {
        infoTitleLabel.text = title
        if lastDocuments != documents || documentationViews.count != documents.count {
            lastDocuments = documents
            documentationViews.forEach {
                $0.removeFromSuperview()
            }
            documentationViews.removeAll()
            let count = documents.count
            documents.enumerated().forEach { [weak self] index, title in
                guard let self = self else {
                    return
                }
                let documentationView = YHIncomeDocumentationView()
                documentationView.setupInfo(title, font: .PFSC_R(ofSize: 13))
                
                self.documentationViews.append(documentationView)
                self.containerView.addSubview(documentationView)

                documentationView.snp.makeConstraints { make in
                    if index == 0 {
                        make.top.equalToSuperview().offset(16)
                    } else {
                        make.top.equalTo(self.documentationViews[index - 1].snp.bottom).offset(12)
                    }
                    make.left.equalToSuperview().offset(16)
                    make.right.lessThanOrEqualToSuperview().offset(-8)
                    if index == count - 1 {
                        make.bottom.equalToSuperview().offset(-16)
                    }
                }
            }
        }
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(containerView)
        infoTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
        containerView.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel)
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(8)
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-8)
        }
    }
}
