//
//  YHIncomeUploadWorkIDCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeUploadWorkIDCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHIncomeUploadWorkIDCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "上传工作证件"
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .brandMainColor
        label.text = "去上传"
        return label
    }()
    
    private lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "blue_right_arrow"))
        return imageView
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
    }
    
    private func setupUI() {
        updateCellCorner(.bottom)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(rightArrowIcon)
        
        infoTitleLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightArrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(18)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
            make.right.equalTo(rightArrowIcon.snp.left)
        }
    }
}
