//
//  YHWholeScreenTipsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHWholeScreenTipsViewType {
    case unKnow // 默认情况
    case residenceInfo // 居住信息
    case degreeType // 学位类型
    case company // 用人单位介绍
    case officialWebsite // 用人单位官网
    case nameCardEducation // 匹配我的名片教育经验
    case nameCardWorkExperience // 匹配我的名片工作经验
    
    case hkPlanQ1 // 赴港计划书问题1
    case hkPlanQ2 // 赴港计划书问题2
    case hkPlanQ3 // 赴港计划书问题3
    case hkPlanQ4 // 赴港计划书问题4
    case hkPlanQ5 // 赴港计划书问题5
    case hkPlanQ6 // 赴港计划书问题6
    case hkPlanQ7 // 赴港计划书问题7
    
    case renewTimeTips // 选择预约在港递交时间
    case hkdToRmbRateTips(_ title: String) // 港元到人民币汇率换算
}

class YHWholeScreenTipsView: UIView {
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        let tap = UITapGestureRecognizer(target: self, action: #selector(dismiss))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x222222, alpha: 0.9)
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    lazy var contentLable: UILabel = {
        let lable = UILabel()
        lable.text = "依日期顺序列出你自出生后曾居住12个月或更长时间的所有国家或地区，包括你的现居国家或地区"
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.textColor = .white
        lable.numberOfLines = 0
        return lable
    }()
    
    lazy var fakeLine: UIView = {
        let view: UIView = UIView()
        view.backgroundColor = .clear
        return view
    }()
    
    private var curType: YHWholeScreenTipsViewType = .unKnow
    
    init(type: YHWholeScreenTipsViewType, targetView: UIView) {
        super.init(frame: UIScreen.main.bounds)
        curType = type
        contentLable.text = getTitleBy(type: type)
        self.createUI(targetView: targetView)
    }
    
    init(message: String, targetView: UIView) {
        super.init(frame: UIScreen.main.bounds)
        contentLable.text = message
        self.createUI(targetView: targetView)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func getTitleBy(type: YHWholeScreenTipsViewType) -> String {
        switch type {
        case .residenceInfo:
            return "依日期顺序列出你自出生后曾居住12个月或更长时间的所有国家或地区，包括你的现居国家或地区"
        case .degreeType:
            return "该内容在学位证上，通常是授予后面，如授予“理学”学士学位，则填理学"
        case .company:
            return "可先填写用人单位名称，选择指定的用人单位后，系统将为您自动填写单位介绍"
        case .officialWebsite:
            return "可先填写用人单位名称，选择指定的用人单位后，系统将为您自动填写单位官网"
        case .nameCardEducation:
            return "该栏目已对好友隐藏，若需重新开启，请前往信息授权处更新设置"
        case .nameCardWorkExperience:
            return "该栏目已对好友隐藏，若需重新开启，请前往信息授权处更新设置"
            
        case .hkPlanQ1:
            return "请以不超过100字简介你在主要工作项目上曾担当的角色、你工作期间曾服务的知名机构/单位或你对有关工作项目及机构的重大贡献"
        case .hkPlanQ2:
            return "请以不超过100字简介你的学业成绩或曾取得的奖项"
        case .hkPlanQ3:
            return "请以不超过100字简介你在所属的专业界别内曾获取由国家或国际认可/著名的团体颁授的专业资格，及曾取得的奖项"
        case .hkPlanQ4:
            return ""
        case .hkPlanQ5:
            return "请以不超过100字简介你的人才清单内相关专业、专业技能或成就（例如你拥有的专利或发明、你在学术研究的领导角色、或你在专业领域获得的国际或地区奖项）如何对香港经济或社会作出重大贡献"
        case .hkPlanQ6:
            return "请以不超过100字简介你与本地商业或学术机构联系及合作的详情"
        case .hkPlanQ7:
            return ""
        case .renewTimeTips:
            return "入境处网址18:00之后可能会存在系统更新，为避免预约时间无法递交，请尽量选择18:00之前的时间"
        case let .hkdToRmbRateTips(title):
            return title
        default:
            return "--"
        }
    }
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    static func show(type: YHWholeScreenTipsViewType, targetView: UIView) {
        let view = YHWholeScreenTipsView(type: type, targetView: targetView)
        view.show()
    }
    
    static func show(message: String, targetView: UIView) {
        let view = YHWholeScreenTipsView(message: message, targetView: targetView)
        view.show()
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    func createUI(targetView: UIView) {
        addSubview(blackMaskView)
        addSubview(whiteContentView)
        whiteContentView.addSubview(contentLable)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        let rrrrr = targetView.convert(targetView.bounds, to: UIApplication.shared.yhKeyWindow())
        var left = rrrrr.origin.x
        let top = rrrrr.origin.y + targetView.height + 5
        
        let offset = left + 214 - KScreenWidth
        if offset > 0 {
            left = left - offset - 16
        }
        
        if case .renewTimeTips = curType {
            // 目标控件的上方
            let otherTop = rrrrr.origin.y - 5
            addSubview(fakeLine)
            fakeLine.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                make.height.equalTo(1)
                make.top.equalToSuperview().offset(otherTop)
            }
            
            whiteContentView.snp.makeConstraints { make in
                make.left.equalToSuperview().offset(left)
                make.bottom.equalTo(fakeLine.snp.top)
                make.width.equalTo(214)
            }
            
            contentLable.snp.makeConstraints { make in
                make.top.left.equalTo(12)
                make.right.bottom.equalTo(-12)
            }
            
        } else {
            // 目标控件的下方
            whiteContentView.snp.makeConstraints { make in
                make.left.equalToSuperview().offset(left)
                make.top.equalToSuperview().offset(top)
                make.width.equalTo(214)
            }
            
            contentLable.snp.makeConstraints { make in
                make.top.left.equalTo(12)
                make.right.bottom.equalTo(-12)
            }
        }
    }
}
