//
//  YHTencentDeskManager.swift
//  galaxy
//
//  Created by alexzzw on 2025/4/30.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import IQKeyboardManagerSwift
import UIKit
import TUICore
import TUIChat
import TUIRoomKit

class YHTencentDeskManager: NSObject {
    
    static let shared = YHTencentDeskManager()
    private let APPGROUP = "group.com.intelligence.galaxy"
    
    private lazy var viewModel: YHButlerServiceViewModel = YHButlerServiceViewModel()
        
    private override init() {
        super.init()
        NotificationCenter.default.addObserver(self, selector: #selector(loginSuccess), name: YhConstant.YhNotification.didLoginSuccessNotifiction, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(logoutSuccess), name: YhConstant.YhNotification.didLogoutSuccessNotifiction, object: nil)
        setupConfig()
        loginSDK()
    }
    
    deinit {
        NotificationCenter.default.removeObserver(self)
    }
    
    private func setupConfig() {
        /// 注释掉群工具：自定义
        TUIChatConfig.default().enableWelcomeCustomMessage = false
        /// 多人会议设置自己的APPGROUP
        ConferenceSession.sharedInstance.setAppGroup(APPGROUP)
        /// 默认关闭消息已读回执
        TUIChatConfig.default().msgNeedReadReceipt = true
        /// 需要隐藏已读未读
        TUIConfig.default().needHideReadReceipt = true
        /// 需要隐藏聊天页点击用户头像显示用户信息
        TUIChatConfig.default().needHideShowUserInfoPage = false
        /// 需要隐藏显示聊天页rightBarButton按钮
        TUIChatConfig.default().needHideNaviMore = false
    }
    
    func loginSDK() {
        guard let userId = YHLoginManager.shared.userModel?.id, userId.count > 0 else {
            return
        }
        
        viewModel.getUsersig { [weak self] success, _ in
            guard let self = self else {
                return
            }
            if success == true {
                let userSig = self.viewModel.userSig ?? ""
                let success: TSucc? = {
                    printLog("loginIM success")
                    YHTUIMessageListManager.shared.setupDataProvider()
                    NotificationCenter.default.post(name: YhConstant.YhNotification.didTxIMLoginSuccessNotifiction, object: nil)
                }
                let failure: TFail? = { code, msg in
                    printLog("loginIM failure: code: \(code) msg: \(msg ?? "")")
                }
                TUILogin.login(YhConstant.TencentIMSDKInfo.sdkAppID, userID: userId, userSig: userSig, succ: success, fail: failure)
            }
        }
        
    }
}

extension YHTencentDeskManager {
    // MARK: - 常用公开方法
    
    @objc private func loginSuccess() {
        loginSDK()
    }
    
    @objc private func logoutSuccess() {
        let success: TSucc? = {
            printLog("logout success")
            YHTUIMessageListManager.shared.logoutIM()
        }
        let failure: TFail? = { code, msg in
            printLog("logout failure: code: \(code) msg: \(msg ?? "")")
        }
        TUILogin.logout(success, fail: failure)
    }
}
