//
//  YHUserInformationModel.swift
//  galaxy
//
//  Created by EDY on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHUserInformationID: Int {
    case id1 = 0 // 真实姓名
    case id2 = 1 // 所在地 省
    case id3 = 2 // 毕业院校
    case id4 = 3 // 所属行业
    case id5 = 4 // 职位
    case id6 = 5 // 所在地
    case id7 = 6 // 星座
    case id8 = 7 // 专业
    case id9 = 8 // 学位
    case id10 = 9 // 所在企业
}

struct YHUserInformationModel {
    var id: YHUserInformationID?
    var title: String?
    var isUserKeyBoard: Bool?
    var prompts: String?
    var message: String?
    var type: YHItemSelectType?
    var value: [String]?
    var isNeed: Bool?
    
    init(id: YHUserInformationID? = nil, title: String? = nil, isUserKeyBoard: Bool? = nil, prompts: String? = nil, message: String? = nil, type: YHItemSelectType? = nil, value: [String]? = nil, isNeed: Bool? = nil) {
        self.id = id
        self.title = title
        self.isUserKeyBoard = isUserKeyBoard
        self.prompts = prompts
        self.message = message
        self.type = type
        self.value = value
        self.isNeed = isNeed
    }
}

class YHMainUserInformationModel: SmartCodable {
    var headUrl: String = ""
    var username: String  = ""
    var area: [String] = []
    var country: String = ""
    var school: String = ""
    var industry: String = ""
    var position: String = ""
    var constellation: String = ""
    var major: String = ""
    var degree: String = ""
    var company: String = ""
    required init() {
    }
}

class YHMainUserInformationSetModel: SmartCodable {
    // 1: 关闭 2：开启
    var uid: String = ""
    var information_to_card: Int = 2 // 弃用
    var authorization_basic_information: Int = 2
    var public_education_experience: Int = 2
    var public_work_experience: Int = 2
    var friend_education_experience: Int = 2
    var friend_work_experience: Int = 2
    var isclick_card: Int = 2
    required init() {
    }
}

class YHUserInformationDetailModel: SmartCodable {
    var username: String = ""
    var avatar: String  = ""
    var address: YHUserInformationDetailAddressModel = YHUserInformationDetailAddressModel()
    var college: String = ""
    var industry: String = ""
    var position: String = ""
    var is_fillin: Int = 0
    required init() {
    }
}

class YHUserInformationDetailAddressModel: SmartCodable {
    var country: String = ""
    var province: String  = ""
    var city: String = ""
    required init() {
    }
}
