//
//  YHImproveTargetListCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHImproveTargetListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHImproveTargetListCell"
    
    var arr: [YHImproveDetailModel] = [] {
        didSet {
            listView.removeSubviews()
            var lastView: YHImproveHKView?
            for (i, item) in arr.enumerated() {
                let itemView = YHImproveHKView(frame: .zero)
                itemView.item = item
                itemView.numLabel.text = "\(i+1)"
                listView.addSubview(itemView)
                itemView.snp.makeConstraints { make in
                    make.left.equalTo(0)
                    make.right.equalTo(0)
                    if let lastView = lastView {
                        make.top.equalTo(lastView.snp.bottom).offset(20)
                    } else {
                        make.top.equalTo(0)
                    }
                    if i == arr.count-1 {
                        make.bottom.equalTo(0)
                    }
                }
                lastView = itemView
            }
        }
    }
    
    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 6.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.textColor = .mainTextColor
        label.text = "提升方案"
        return label
    }()
    
    lazy var subtitleLabel: UILabel = {
        let label = UILabel()
        label.text = "以下指引供您按需参考"
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = .init(hex: 0x8993A2)
        return label
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var listView: UIView = {
        let v = UIView()
        return v
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        contentView.backgroundColor = .clear
        self.backgroundColor = .clear
        selectionStyle = .none
        
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(subtitleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(listView)

        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.width.equalTo(69)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.bottom.equalTo(titleLabel)
            make.left.equalTo(titleLabel.snp.right).offset(6)
            make.right.equalTo(-16)
            make.height.equalTo(20)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.height.equalTo(0.5)
        }
        
        listView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-16)
            make.top.equalTo(lineView.snp.bottom).offset(20)
        }
    }

}
