//
//  YHGCIncomeRecordWorkExperienceViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCIncomeRecordWorkExperienceViewModel: YHBaseViewModel {
    var position: YHGCWorkExperienceModel = YHGCWorkExperienceModel()
    var saveWorkModel: YHGCIncomeRecordSaveWorkModel = YHGCIncomeRecordSaveWorkModel()
    
    override init() {
        super.init()
    }

    func requestWorkPositionDetail(_ workId: Int, _ orderID: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let param: [String: Any] = ["id": workId, "order_id": orderID]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.gcworkDetail
        _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHGCWorkExperienceModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.position = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

    func saveWorkPosition(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let address = ["area": position.location.area,
                       "country": position.location.country,
                       "foreign": position.location.foreign] as [String: Any]
        let params: [String: Any] = ["id": position.id,
                                     "order_id": position.order_id,
                                     "company_name": position.company_name,
                                     "entry_time": position.entry_time,
                                     "departure_time": position.departure_time,
                                     "position": position.position,
                                     "has_work_certificate": position.has_work_certificate,
                                     "company_type": position.company_type,
                                     "company_type_other": position.company_type_other,
                                     "location_aboard": position.location_aboard,
                                     "location": address,
                                     "type_of_income": position.type_of_income,
                                     "income": position.income,
                                     "turnover": position.turnover,
                                     "verify": 1]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.gcWorkSave
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHGCIncomeRecordSaveWorkModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.saveWorkModel = result
                self.position.id = result.id
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
