//
//  YHMediaBrowserViewController.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import Kingfisher
import UIKit
import JXPhotoBrowser
import Photos
import PhotosUI

class YHMediaBrowserViewController: JXPhotoBrowser {

    var deleteMediaBlock: ((Int) -> Void)?
    
    var dismissBlock: (() -> Void)?
    
    lazy var navBar: UIView = {
        let v = UIView()
        
        let backBtn = UIButton()
        backBtn.setImage(UIImage(named: "nav_back_white"), for: .normal)
        backBtn.addTarget(self, action: #selector(didBackBtnClicked), for: .touchUpInside)
        v.addSubview(backBtn)
        
        let deleteBtn = UIButton()
        let img = UIImage(named: "media_brower_delete")
        let templateImage = img?.withRenderingMode(.alwaysTemplate)
        deleteBtn.setImage(templateImage, for: .normal)
        deleteBtn.imageView?.tintColor = .white
        deleteBtn.addTarget(self, action: #selector(didDeleteBtnClicked), for: .touchUpInside)
        v.addSubview(deleteBtn)
        
        backBtn.snp.makeConstraints { make in
            make.width.height.equalTo(44)
            make.left.equalToSuperview()
            make.bottom.equalToSuperview()
        }
        
        deleteBtn.snp.makeConstraints { make in
            make.width.height.equalTo(44)
            make.right.equalToSuperview()
            make.bottom.equalToSuperview()
        }
        
        return v
    }()
    
    @objc func didBackBtnClicked() {
        dismiss()
    }
    
    @objc func didDeleteBtnClicked() {
        let index = self.browserView.pageIndex
        deleteMediaBlock?(index)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.addSubview(navBar)
        navBar.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(k_Height_NavigationtBarAndStatuBar)
        }
    }
    
    deinit {
        printLog("YHMediaBrowserViewController deinit")
    }
    
    override func dismiss() {
        super.dismiss()
        dismissBlock?()
    }
}
