//
//  YHSignSuccessCell.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSignActivityInfoCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHSignActivityInfoCell"
    
    private let containerView = UIView()
    private let titleLabel = UILabel()
    private let thumbnailImageView = UIImageView()
    private let timeLabel = UILabel()
    private let timeValueLabel = UILabel()
    private let locationLabel = UILabel()
    private let locationValueLabel = UILabel()
    private let subLocationLabel = UILabel()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        backgroundColor = .clear
        selectionStyle = .none
        
        containerView.backgroundColor = .white
        containerView.layer.cornerRadius = 6
        contentView.addSubview(containerView)
        
        titleLabel.font = .PFSC_B(ofSize: 18)
        titleLabel.textColor = .brandGrayColor8
        titleLabel.numberOfLines = 0
        containerView.addSubview(titleLabel)
    
        thumbnailImageView.contentMode = .scaleAspectFit
        thumbnailImageView.layer.cornerRadius = 4
        thumbnailImageView.clipsToBounds = true
        containerView.addSubview(thumbnailImageView)
        
        timeLabel.text = "时间"
        timeLabel.font = .PFSC_R(ofSize: 14)
        timeLabel.textColor = .brandGrayColor6
        containerView.addSubview(timeLabel)
        
        timeValueLabel.font = .PFSC_R(ofSize: 14)
        timeValueLabel.textColor = .brandGrayColor8
        timeValueLabel.numberOfLines = 0
        containerView.addSubview(timeValueLabel)
        
        locationLabel.text = "地点"
        locationLabel.font = .PFSC_R(ofSize: 14)
        locationLabel.textColor = .brandGrayColor6
        containerView.addSubview(locationLabel)
        
        locationValueLabel.font = .PFSC_R(ofSize: 14)
        locationValueLabel.textColor = .brandGrayColor8
        locationValueLabel.numberOfLines = 0
        containerView.addSubview(locationValueLabel)
        
        subLocationLabel.font = .PFSC_R(ofSize: 12)
        subLocationLabel.textColor = .brandGrayColor5
        subLocationLabel.numberOfLines = 0
        containerView.addSubview(subLocationLabel)
        
        // 约束
        containerView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(24)
            make.left.equalToSuperview().offset(20)
            make.right.equalTo(thumbnailImageView.snp.left).offset(-17)
        }
        
        thumbnailImageView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.width.height.equalTo(72)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.top.greaterThanOrEqualTo(titleLabel.snp.bottom).offset(24)
            make.top.greaterThanOrEqualTo(thumbnailImageView.snp.bottom).offset(24)
            make.left.equalToSuperview().offset(20)
            make.width.equalTo(50)
        }
        
        timeValueLabel.snp.makeConstraints { make in
            make.centerY.equalTo(timeLabel)
            make.left.equalTo(timeLabel.snp.right).offset(16)
            make.right.equalToSuperview().offset(-20)
        }
        
        locationLabel.snp.makeConstraints { make in
            make.top.equalTo(timeLabel.snp.bottom).offset(13)
            make.left.equalToSuperview().offset(20)
            make.width.equalTo(50)
        }
        
        locationValueLabel.snp.makeConstraints { make in
            make.top.equalTo(locationLabel)
            make.left.equalTo(locationLabel.snp.right).offset(16)
            make.right.equalToSuperview().offset(-20)
        }
        
        subLocationLabel.snp.makeConstraints { make in
            make.top.equalTo(locationValueLabel.snp.bottom).offset(8)
            make.left.equalTo(locationValueLabel)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(-20)
        }
    }
    
    func configure(with model: YHSignSuccessActivity) {
        titleLabel.text = model.name
        timeValueLabel.text = model.getDateString(format: "yyyy-MM-dd")
        locationValueLabel.text = model.place
        subLocationLabel.text = model.guidance
        thumbnailImageView.sd_setImage(with: URL(string: model.cover), placeholderImage: UIImage(named: "global_default_image"), context: nil)
        
    }
}
