//
//  YHServiceSectionView.swift
//  galaxy
//
//  Created by EDY on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHServiceSectionView: UIView {
    
    static let viewH: CGFloat = 48.0

    typealias Block = (YHClassifyModel) -> Void
    var block: Block?
    typealias HkBlock = (YHHKEventModel) -> Void
    var hkBlock: HkBlock?
    
    var items: [YHClassifyModel] = [] {
        didSet {
            self.myCollectView.reloadData()
        }
    }
    
    var dataSource: [YHHKEventModel] = [] {
        didSet {
            self.myCollectView.reloadData()
        }
    }
    var type: Int = 0
    
    var selectIndex = 0
    lazy var myCollectView = {
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.itemSize = CGSize(width: 75, height: 32)
        flowLayout.minimumInteritemSpacing = 12.0
        flowLayout.minimumLineSpacing = 12.0
        flowLayout.scrollDirection = .horizontal
        
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.backgroundColor = .white
        collectinoView.contentInset = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 20)
        collectinoView.register(YHServiceSectionCollectionViewCell.self, forCellWithReuseIdentifier: YHServiceSectionCollectionViewCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.alwaysBounceVertical = true
        collectinoView.bounces = false
        collectinoView.showsHorizontalScrollIndicator = false
        collectinoView.showsVerticalScrollIndicator = false
        return collectinoView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        backgroundColor = .white
        addSubview(myCollectView)
        myCollectView.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
//        self.myCollectView.es.addInfiniteScrolling {
//            self.loadFakeData()
//        }
    }
    
}

extension YHServiceSectionView: UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if type == 0 {
            return items.count
        } else {
            return dataSource.count
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHServiceSectionCollectionViewCell.cellReuseIdentifier, for: indexPath) as? YHServiceSectionCollectionViewCell else { return UICollectionViewCell() }
        if type == 0 {
            cell.dataSource = items[indexPath.row]
        } else {
            cell.setTag(dataSource[indexPath.row].tag)
        }
        if indexPath.row == selectIndex {
            cell.setSelectedStyle()
        } else {
            cell.setDeSelectedStyle()
        }
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        selectIndex = indexPath.row
        collectionView.reloadData()
        if type == 0 {
            let model = items[indexPath.row]
            if let block = block {
                block(model)
            }
        } else {
            let model = dataSource[indexPath.row]
            if let block = hkBlock {
                block(model)
            }
        }
        print("index is \(indexPath.row)")
    }
}

class YHServiceSectionCollectionViewCell: UICollectionViewCell {
    static let cellReuseIdentifier = "YHServiceSectionCollectionViewCell"
 
    func setSelectedStyle() {
        contentView.backgroundColor = UIColor.brandMainColor
        descripeLable.textColor = UIColor.white
    }
 
    func setDeSelectedStyle() {
        contentView.backgroundColor = UIColor(hex: 0xf4f6fa)
        descripeLable.textColor = UIColor(hex: 0x94a3bb)
    }
    
    var dataSource: YHClassifyModel? {
        didSet {
            updataAllSubViews()
        }
    }
    
    lazy var descripeLable: UILabel = {
        let label = UILabel()
        label.text = "赴港"
        label.textColor = UIColor(hex: 0x94a3bb)
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textAlignment = .center
        return label
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    private func setupUI() {
        
        contentView.backgroundColor = UIColor(hex: 0xf4f6fa)
        contentView.clipsToBounds = true
        contentView.layer.cornerRadius = 16
        
        contentView.addSubview(descripeLable)
        descripeLable.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
    }
    
    func updataAllSubViews() {
        guard let dataSource = dataSource else { return }
        descripeLable.text = dataSource.name
    }
    
    func setTag(_ tag: String) {
        descripeLable.text = tag
    }
}
