//
//  YHHKRecordsInfoItemCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsInfoItemCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHHKRecordsInfoItemCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor50
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.font = .PFSC_R(ofSize: 14)
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, detail: String?, topMargin: CGFloat = 18, bottomMargin: CGFloat = 18) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
        infoTitleLabel.snp.remakeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(topMargin)
            make.bottom.equalToSuperview().offset(-bottomMargin)
        }
    }
}

extension YHHKRecordsInfoItemCell {
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        infoTitleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(9)
            make.bottom.equalToSuperview().offset(-9)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(6)
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
        }
    }
}
