//
//  YHResignDocumentCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignDocumentCell: UITableViewCell {
    
    lazy var subContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 8, corner: .none)
        view.backgroundColor = .white
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func updateCellCorner(_ cellType: YHResignRoundCellType) {
        switch cellType {
        case .top:
            subContainerView.corner = [.topLeft, .topRight]
        case .mid:
            subContainerView.corner = .none
        case .bottom:
            subContainerView.corner = [.bottomLeft, .bottomRight]
        case .single:
            subContainerView.corner = .allCorners
        }
    }
}

extension YHResignDocumentCell {
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(subContainerView)
        subContainerView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
        }
    }
}
