//
//  YHResignUploadTravelCardFootViewController.swift
//  galaxy
//
//  Created by EDY on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHResignUploadTravelCardFootViewController: YHBaseViewController {
    var type: Int = 0
    var imageView: UIImageView!
    var linkButton: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
}

extension YHResignUploadTravelCardFootViewController {
    func loadData() {
        
    }
    
    func setupUI() {
        gk_navBarAlpha = 0
        gk_navigationBar.isHidden = true
        view.backgroundColor = .white
        imageView = {
            let tableView = UIImageView()
            return tableView
        }()
        view.addSubview(imageView)
        var height = 0.0
        if type == 0 {
            height = 488.fix
            imageView.image = UIImage(named: "resign_upload_travel_foot_one")
        } else {
            height = 659.fix
            imageView.image = UIImage(named: "resign_upload_travel_foot_two")
        }
        imageView.snp.makeConstraints { make in
            make.top.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(height)
        }
        
        if type == 1 {
            linkButton = {
                let tableView = UIButton(type: .custom)
                tableView.addTarget(self, action: #selector(click), for: .touchUpInside)
                return tableView
            }()
            view.addSubview(linkButton)
            linkButton.snp.makeConstraints { make in
                make.left.equalTo(44)
                make.right.equalTo(-44)
                make.top.equalTo(152.fix)
                make.height.equalTo(40.fix)
            }
        }
        view.layer.cornerRadius = kCornerRadius6
        view.layer.maskedCorners = [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]
    }
    
    @objc func click() {
        let vc = YHH5WebViewVC()
        vc.url = "https://www.ctshk.com/mep/zh/"
        vc.isFullScreenFlag = false
        UIViewController.current?.navigationController?.pushViewController(vc)
    }
}

extension YHResignUploadTravelCardFootViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}
