//
//  LBXScanLineAnimation.swift
//  swiftScan
//
//  Created by lbxia on 15/12/9.
//  Copyright © 2015年 xialibing. All rights reserved.
//

import UIKit

class LBXScanLineAnimation: UIImageView {

    var isAnimationing = false
    var animationRect: CGRect = CGRect.zero
    
    func startAnimatingWithRect(animationRect: CGRect, parentView: UIView, image: UIImage?) {
        self.image = image
        self.animationRect = animationRect
        parentView.addSubview(self)
        
        self.isHidden = false
        
        isAnimationing = true
        
        if image != nil {
            stepAnimation()
        }
    }
    
    @objc func stepAnimation() {
        if !isAnimationing {
            return
        }
        
        guard let image = self.image else { return }
        
        // 重要：取消之前可能存在的延迟调用
        NSObject.cancelPreviousPerformRequests(withTarget: self,
                                               selector: #selector(LBXScanLineAnimation.stepAnimation),
                                               object: nil)
        
        var frame: CGRect = animationRect
        
        let hImg = image.size.height * animationRect.size.width / image.size.width
        
        // 重置到起始位置
        frame.origin.y = animationRect.origin.y
        frame.size.height = hImg
        self.frame = frame
        self.alpha = 0.0
        
        UIView.animate(withDuration: 1.4, animations: { [weak self] () in
            guard let self = self else { return }
            
            self.alpha = 1.0
            
            var frame = self.animationRect
            let hImg = image.size.height * self.animationRect.size.width / image.size.width
            
            frame.origin.y = self.animationRect.origin.y + (self.animationRect.size.height - hImg)
            frame.size.height = hImg
            
            self.frame = frame
            
        }, completion: { [weak self] (_: Bool) in
            guard let self = self else { return }
            
            // 检查动画是否应该继续
            if self.isAnimationing {
                self.perform(#selector(LBXScanLineAnimation.stepAnimation),
                           with: nil,
                           afterDelay: 0.3)
            }
        })
    }
    
    func stopStepAnimating() {
        // 先设置标记为false，阻止新的动画开始
        isAnimationing = false
        
        // 取消所有延迟调用
        NSObject.cancelPreviousPerformRequests(withTarget: self)
        
        // 停止当前的动画
        self.layer.removeAllAnimations()
        
        // 隐藏视图
        self.isHidden = true
        
        // 重置frame到初始位置
        if !animationRect.isEmpty {
            var frame = animationRect
            if let image = self.image {
                let hImg = image.size.height * animationRect.size.width / image.size.width
                frame.origin.y = animationRect.origin.y
                frame.size.height = hImg
            }
            self.frame = frame
        }
    }
    
    static public func instance() -> LBXScanLineAnimation {
        return LBXScanLineAnimation()
    }
    
    deinit {
        NSObject.cancelPreviousPerformRequests(withTarget: self)
        stopStepAnimating()
    }
}
