//
//  YHOtherServiceViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHOtherServiceViewController: YHBaseViewController {
    let homeViewModel: YHHomePageViewModel = YHHomePageViewModel()

    var canScroll: Bool = true {
        didSet {
            for vc in arrItemVCs {
                vc.vcCanScroll = canScroll
            }
        }
    }
    var items: [YHClassifyModel] = []
    var classID = 0
    
    var myDefaultNavItemIndex: Int = 0 {
        didSet {
            self.segmentedView.selectItemAt(index: self.myDefaultNavItemIndex)
        }
    }
    
    var arrItemTitles: [String] = []
    var arrItemVCs: [YHOtherServiceListViewController] = []
    var segmentedView: JXSegmentedView = JXSegmentedView(frame: CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: KScreenWidth, height: 55))
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.titles = arrItemTitles
        
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 14)
        dataSource.titleSelectedColor = UIColor.labelTextColor2
        
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleSelectedColor = UIColor.white
        dataSource.isTitleMaskEnabled = true
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        dataSource.itemSpacing = 24
        return dataSource
    }()
    
    // 分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        
        // segmentedViewDataSource一定要通过属性强持有！！！！！！！！！
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        view.addSubview(segmentedView)

        segmentedView.listContainer = listContainerView
        view.addSubview(listContainerView)
        
        // 分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        
        // 配置指示器
        let indicator = JXSegmentedIndicatorBackgroundView()
        indicator.indicatorColor = UIColor.brandMainColor
        indicator.indicatorHeight = 32
        segmentedView.indicators = [indicator]
        segmentedView.defaultSelectedIndex = self.myDefaultNavItemIndex
        
        getData()
    }

    func getData() {
        if classID == 3 {
            gk_navTitle = "身份福利"
        } else if classID == 4 {
            gk_navTitle = "办理攻略"
        } else if classID == 5 {
            gk_navTitle = "客户成功"
        }
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1.0
        homeViewModel.getHomeClassify {[weak self] _, _ in
            guard let self = self, let classify = self.homeViewModel.classify  else { return }
            for item in classify {
                let model = item as YHHomeClassifyModel
                if model.id == self.classID {
                    self.items = model.children
                    self.arrItemTitles.removeAll()
                    for item in model.children {
                        self.arrItemTitles.append(item.name)
                        let vc = YHOtherServiceListViewController()
                        vc.classId = item.id
                        arrItemVCs.append(vc)
                    }
                }
                self.segmentedDataSource.titles = arrItemTitles
                self.segmentedView.dataSource = segmentedDataSource
                self.segmentedView.reloadData()
                self.updateViews()
            }
        }
    }
    
    func updateViews() {
        if arrItemTitles.count != 1 {
            segmentedView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: view.bounds.size.width, height: 55)
            listContainerView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar + 55, width: view.bounds.size.width, height: view.bounds.size.height - 55 - k_Height_NavigationtBarAndStatuBar)
        } else {
            segmentedView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: view.bounds.size.width, height: 0)
            listContainerView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: view.bounds.size.width, height: view.bounds.size.height - k_Height_NavigationtBarAndStatuBar)
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)

        // 处于第一个item的时候，才允许屏幕边缘手势返回
        navigationController?.interactivePopGestureRecognizer?.isEnabled = (segmentedView.selectedIndex == 0)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)

        // 离开页面的时候，需要恢复屏幕边缘手势，不能影响其他页面
        navigationController?.interactivePopGestureRecognizer?.isEnabled = true
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        if arrItemTitles.count != 1 {
            segmentedView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: view.bounds.size.width, height: 55)
            listContainerView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar + 55, width: view.bounds.size.width, height: view.bounds.size.height - 55 - k_Height_NavigationtBarAndStatuBar)
        } else {
            segmentedView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: view.bounds.size.width, height: 0)
            listContainerView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: view.bounds.size.width, height: view.bounds.size.height - k_Height_NavigationtBarAndStatuBar)
        }
        
        segmentedView.backgroundColor = .white
    }
}

extension YHOtherServiceViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
    }
}

extension YHOtherServiceViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return arrItemVCs[index] as JXSegmentedListContainerViewListDelegate
    }
}
