//
//  YHMyFileListHeaderView.swift
//  galaxy
//
//  Created by edy on 2024/7/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFileListHeaderView: UIView {

    var isShowCorner: Bool = false {
        didSet {
            self.whiteCornerView.isHidden = !isShowCorner
            self.whiteContentView.backgroundColor = isShowCorner ? UIColor.clear : UIColor.white
        }
    }
    lazy var columnView: UIView = {
        
        let view = UIView()
        view.backgroundColor = .white
        
        let bgView = UIView()
        bgView.backgroundColor = UIColor.init(hex: 0xE5E9F2, alpha: 0.3)
        view.addSubview(bgView)
        
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor50
        label1.font = UIFont.PFSC_R(ofSize: 12)
        label1.text = "内容"
        label1.textAlignment = .left
        bgView.addSubview(label1)
        
        let label2 = UILabel()
        label2.textColor = UIColor.mainTextColor50
        label2.font = UIFont.PFSC_R(ofSize: 12)
        label2.text = "状态"
        label2.textAlignment = .right
        bgView.addSubview(label2)
        
        bgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }

        label1.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.top.equalTo(11.0)
        }
        
        label2.snp.makeConstraints { make in
            make.right.equalTo(-38)
            make.top.equalTo(11.0)
        }
        
        return view
    }()
    
    lazy var headerView = {
        let view = UIView()
        view.clipsToBounds = true
        return view
    }()
    
    lazy var grayView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xDEE5F1)
        view.layer.cornerRadius = 6.0
        view.layer.borderWidth = 0.5
        view.layer.borderColor = UIColor.init(hex: 0xDEE5F1).cgColor
        view.clipsToBounds = true
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.clipsToBounds = true
        return view
    }()
    
    lazy var whiteCornerView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 6.0
        view.isHidden = true
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor
        label1.font = UIFont.PFSC_M(ofSize: 18)
        label1.textAlignment = .center
        label1.text = ""
        return label1
    }()
    
    lazy var titleBgImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "my_filelist_title_bg"))
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        self.clipsToBounds = true
        self.addSubview(self.whiteCornerView)
        self.addSubview(self.whiteContentView)
        self.whiteContentView.addSubview(self.titleBgImgView)
        self.whiteContentView.addSubview(self.titleLabel)
        self.whiteContentView.addSubview(self.headerView)
        self.headerView.addSubview(self.grayView)
        let lineView = UIView()
        lineView.backgroundColor = UIColor.init(hex: 0xDEE5F1)
        self.headerView.addSubview(lineView)
        self.grayView.addSubview(self.columnView)

        self.whiteCornerView.snp.makeConstraints { make in
            make.left.right.top.equalTo(whiteContentView)
            make.bottom.equalToSuperview().offset(7)
        }
        self.titleLabel.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.centerX.equalToSuperview()
            make.height.equalTo(25)
        }
        
        self.titleBgImgView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.bottom.equalTo(self.titleLabel)
            make.width.equalTo(91)
            make.height.equalTo(9)
        }
        
        self.headerView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(19)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(38)
            make.bottom.equalToSuperview()
        }
        
        lineView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        self.grayView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(1)
            make.height.equalTo(38.0+6.0)
        }
        
        self.columnView.snp.makeConstraints { make in
            make.left.top.equalTo(0.5)
            make.right.equalTo(-0.5)
            make.bottom.equalTo(0.5)
        }

        self.whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.bottom.equalToSuperview()
        }
    }
}
