//
//  YHHKRecordsSectionHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsSectionHeaderCell: YHHKRecordsSectionItemBaseCell {

    static let cellReuseIdentifier = "YHHKRecordsSectionHeaderCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, cellType: YHResignRoundCellType = .top) {
        infoTitleLabel.text = title
        bottomLineView.isHidden = cellType != .top
        updateCellCorner(cellType)
    }
    
}

extension YHHKRecordsSectionHeaderCell {
    
    private func setupUI() {
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(bottomLineView)
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(14)
            make.right.equalToSuperview().offset(-14)
            make.height.equalTo(0.5)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalTo(bottomLineView.snp.top).offset(-10)
        }
    }
}
