//
//  YHResignAppointedScheduleSingleItemView.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignAppointedScheduleSingleItemView: UIView {
    
    var clickConfirmBtnBlock: ((YHResignConfirmHKStatus) -> Void)?
    var applyPaymentBlock: (() -> Void)?

    var confirmHKStatus: YHResignConfirmHKStatus = .canConfirmHK
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var applicantNamesLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        label.text = "申请人："
        return label
    }()
    
    lazy var haveConfirmInHKLabel: UILabel = {
        let label = UILabel()
        label.text = "已确认在港"
        label.font = UIFont.PFSC_M(ofSize: 13)
        label.textColor = .init(hex: 0x3CC694)
        label.isHidden = true
        return label
    }()
    
    lazy var confirmInHKBtn: UIButton = {
        let btn = UIButton()
        btn.layer.cornerRadius = 2.0
        btn.backgroundColor = .brandMainColor
        btn.setTitleColor(.white, for: .normal)
        btn.setTitle("确认在港", for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 11)
        btn.addTarget(self, action: #selector(didConfirmInHKBtnClicked), for: .touchUpInside)
        btn.isHidden = true
        return btn
    }()
    
    lazy var applyFeeBtn: UIButton = {
        let btn = UIButton()
        btn.layer.cornerRadius = 2.0
        btn.backgroundColor = .brandMainColor
        btn.setTitleColor(.white, for: .normal)
        btn.setTitle("申请缴费", for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 11)
        btn.addTarget(self, action: #selector(didApplyFeeBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var submitTimeLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = .mainTextColor(alpha: 0.5)
        label.text = "预约递交时间: 0000-00-00 00:00"
        return label
    }()
    
    lazy var confirmHKTimeLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = .mainTextColor(alpha: 0.5)
        label.text = "确认在港时间: 0000-00-00 00:00"
        return label
    }()
    
    lazy var scheduleView: YHResignAppointedScheduleLineView = {
        let view = YHResignAppointedScheduleLineView(frame: .zero)
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didConfirmInHKBtnClicked() {
        clickConfirmBtnBlock?(self.confirmHKStatus)
    }
    
    @objc func didApplyFeeBtnClicked() {
        applyPaymentBlock?()
    }
    
    func updateModel(_ model: YHResignAppointGroup) {
        var names = "申请人："
        for (index, user) in model.user_list.enumerated() {
            names += user.name
            if index != model.user_list.count-1 {
                names += "、"
            }
        }
        applicantNamesLabel.text = names
        submitTimeLabel.text = "预约递交时间: " + model.getSubmitHKTime()
        confirmHKTimeLabel.text = "确认在港时间: " + model.getConfirmHKTime()
        
        self.confirmHKStatus = model.getConfirmInHKStatus()
        
        haveConfirmInHKLabel.isHidden = (self.confirmHKStatus != .haveConfirmHK)
        confirmInHKBtn.isHidden = (self.confirmHKStatus == .haveConfirmHK)
        
        var statusWidth = 71.0
//        if self.confirmHKStatus == .waitConfirmHK {
//            statusWidth = 71.0
//        } else
        
        if self.confirmHKStatus == .canConfirmHK {
            statusWidth = 68.0
        } else if self.confirmHKStatus == .haveConfirmHK {
            statusWidth = 65.0
            let applyWidth = model.isNeedPayment() ? 68.0 : 0.0
            statusWidth += applyWidth
        }
        applicantNamesLabel.snp.updateConstraints { make in
            make.right.equalTo(-18-statusWidth-18)
        }
        
//        if self.confirmHKStatus == .waitConfirmHK {
//            confirmInHKBtn.setTitle("待确认在港", for: .normal)
//            confirmInHKBtn.setTitleColor(.mainTextColor, for: .normal)
//            confirmInHKBtn.backgroundColor = .init(hex: 0xF4F6FA)
//            confirmInHKBtn.snp.updateConstraints { make in
//                make.width.equalTo(71)
//            }
//            
//        } else
        
        if self.confirmHKStatus == .canConfirmHK {
            confirmInHKBtn.setTitle("确认在港", for: .normal)
            confirmInHKBtn.setTitleColor(.white, for: .normal)
            confirmInHKBtn.backgroundColor = .brandMainColor
            confirmInHKBtn.snp.updateConstraints { make in
                make.width.equalTo(68)
            }
        }
        
        confirmHKTimeLabel.isHidden = true
        confirmHKTimeLabel.snp.removeConstraints()
        applyFeeBtn.isHidden = !model.isNeedPayment()
        haveConfirmInHKLabel.snp.remakeConstraints { make in
            if model.isNeedPayment() {
                make.right.equalTo(applyFeeBtn.snp.left).offset(-8)
                
            } else {
                make.right.equalTo(-18)
            }
            make.top.equalTo(lineView.snp.bottom).offset(18)
            make.height.equalTo(18)
        }
        
        if self.confirmHKStatus == .haveConfirmHK { // 已确认在港 需要显示确认在港时间
            confirmHKTimeLabel.isHidden = false
            confirmHKTimeLabel.snp.remakeConstraints { make in
                make.left.equalTo(18)
                make.right.equalTo(-18)
                make.top.equalTo(submitTimeLabel.snp.bottom).offset(8)
            }
            scheduleView.snp.remakeConstraints { make in
                make.left.equalTo(18)
                make.right.equalTo(-18)
                make.top.equalTo(confirmHKTimeLabel.snp.bottom).offset(18)
                make.height.equalTo(84.0)
                make.bottom.equalTo(-18)
            }
            
        } else { // 不需要显示确认在港时间
            
            scheduleView.snp.remakeConstraints { make in
                make.left.equalTo(18)
                make.right.equalTo(-18)
                make.top.equalTo(submitTimeLabel.snp.bottom).offset(18)
                make.height.equalTo(84.0)
                make.bottom.equalTo(-18)
            }
        }
        
        scheduleView.updateDates(confirmDate: model.determine_hk_at, submitDate: model.actually_submit_at, watchDate: model.result_file_at)
        
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    func createUI() {
        self.addSubview(lineView)
        self.addSubview(applicantNamesLabel)
        self.addSubview(confirmInHKBtn)
        self.addSubview(applyFeeBtn)
        self.addSubview(haveConfirmInHKLabel)
        self.addSubview(submitTimeLabel)
        self.addSubview(confirmHKTimeLabel)
        self.addSubview(scheduleView)

        lineView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        applicantNamesLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18-71-18)
            make.top.equalTo(lineView.snp.bottom).offset(18)
        }
        
        confirmInHKBtn.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.width.equalTo(68)
            make.height.equalTo(28)
            make.top.equalTo(lineView.snp.bottom).offset(18)
        }
        
        applyFeeBtn.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.width.equalTo(68)
            make.height.equalTo(28)
            make.centerY.equalTo(haveConfirmInHKLabel)
        }
        
        haveConfirmInHKLabel.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(lineView.snp.bottom).offset(18)
            make.height.equalTo(18)
        }
        
        submitTimeLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(applicantNamesLabel.snp.bottom).offset(8)

        }
        
        confirmHKTimeLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(submitTimeLabel.snp.bottom).offset(8)
        }
        
        scheduleView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(confirmHKTimeLabel.snp.bottom).offset(18)
            make.height.equalTo(84.0)
            make.bottom.equalTo(-18)
        }
    }
}
