//
//  YHOtherSelecteItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHOtherSelecteItemType: Int {
    case unknow = 0
    case language = 1 // 语言能力
    case skill = 2 // 专业技能
}

class YHOtherSelecteItemView: UIView {
    
    // 1- 一行布局  2-2行布局
    var type: Int = 1 {
        didSet {
            layoutIfNeeded()
        }
    }
    
    var needCheckFlag: Bool = false {
        didSet {
            layoutIfNeeded()
        }
    }
    
    var showLongTimeButtonFlag: Bool = false {
        didSet {
            layoutMyUI()
        }
    }
    
    typealias ItemBlock = (_ flag: Bool, _ text: String) -> Void
    var block: ItemBlock?
    
    typealias TextViewBlock = (_ firstTxt: String, _ secondTxt: String) -> Void
    var textBlock: TextViewBlock?
    
    lazy var longTimeButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "main_time_normal"), for: .normal)
        button.setImage(UIImage(named: "login_privacy_agree"), for: .selected)
        button.setTitleColor(UIColor.mainTextColor, for: .normal)
        button.setTitle("至今", for: .normal)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.contentHorizontalAlignment = .right
        button.addTarget(self, action: #selector(longTimeButtonClick), for: .touchUpInside)
        button.imageEdgeInsets = UIEdgeInsets(top: 10, left: 0, bottom: 10, right: 30)
        button.isSelected = false
        button.isHidden = true
        return button
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    lazy var textField: UITextField = {
        let label = UITextField()
        label.placeholder = "请选择"
        label.isEnabled = false
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    // 提示lable
    private lazy var noTextTipsLable: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "请选择x"
        return label
    }()
    
    var title: String? {
        didSet {
            if let question = title {
                let str = "* "+question
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: UIFont.PFSC_R(ofSize: 14),
                    .foregroundColor: UIColor.mainTextColor
                ]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                let starRange = NSRange(location: 0, length: 1)
                questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                titleLabel.attributedText = questionAttrStr
            }
        }
    }
    
    var subHoldView: UIView = {
        let view = UIView()
        return view
    }()
    
    let firstTextView: YHCustomTextView = YHCustomTextView()
    let secondTextView: YHCustomTextView = YHCustomTextView()
    
    private let rightIcon = UIImageView()
    override func layoutSubviews() {
        super.layoutSubviews()
        
        layoutMyUI()
    }
}

extension YHOtherSelecteItemView {
    func setupUI() {
        addSubview(bottomLine)
        addSubview(titleLabel)
        addSubview(subHoldView)
        addSubview(noTextTipsLable)
        
        title = "开始时间"
        rightIcon.image = UIImage(named: "form_right_arrow")
        rightIcon.contentMode = .scaleAspectFill
        
        subHoldView.addSubview(rightIcon)
        rightIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalToSuperview()
            make.width.height.equalTo(20)
        }
        subHoldView.addSubview(textField)
        textField.snp.makeConstraints { make in
            make.right.equalTo(rightIcon.snp.left).offset(-4)
            make.bottom.top.left.equalToSuperview()
        }
        
        //
        addSubview(longTimeButton)
        longTimeButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(32)
            make.width.equalTo(43)
        }
        
        addSubview(firstTextView)
        addSubview(secondTextView)
        
        firstTextView.block = { _ in
            self.textBlock?(self.firstTextView.myTextView.text, self.secondTextView.myTextView.text)
        }
        
        secondTextView.block = { _ in
            self.textBlock?(self.firstTextView.myTextView.text, self.secondTextView.myTextView.text)
        }
    }
    
    @objc func longTimeButtonClick() {
        longTimeButton.isSelected = !longTimeButton.isSelected
        if longTimeButton.isSelected {
            block?(true, "至今")
            textField.placeholder = ""
        } else {
            block?(false, "")
            textField.placeholder = "请选择"
        }
    }
}

extension YHOtherSelecteItemView {
    func updateKeyName(name: String, keyValue: String, firstTxt: String = "", secondTxt: String = "") {
        
        if type == 1 {
            noTextTipsLable.text = "请选择" + name
        } else {
            noTextTipsLable.text = "请选择"
        }
        
        title = name
        textField.text = keyValue
        
        firstTextView.myTextView.text = firstTxt
        secondTextView.myTextView.text = secondTxt
        secondTextView.layoutIfNeeded()
        layoutMyUI()
    }
    
    func layoutMyUI() {
        
        titleLabel.snp.removeConstraints()
        subHoldView.snp.removeConstraints()
        bottomLine.snp.removeConstraints()
        noTextTipsLable.snp.removeConstraints()
        
        if type == 1 {
            if needCheckFlag == true {
                titleLabel.snp.remakeConstraints { make in
                    make.top.equalToSuperview().offset(kMargin)
                    make.left.equalToSuperview()
                    make.width.equalTo(80)
                    make.height.equalTo(20)
                }
                
                subHoldView.snp.remakeConstraints { make in
                    make.top.equalTo(titleLabel.snp.top)
                    make.bottom.equalTo(titleLabel.snp.bottom)
                    make.right.equalToSuperview()
                    make.left.equalTo(titleLabel.snp.right).offset(40)
                }
                
                if textField.isEmpty == true {
                    if longTimeButton.isSelected {
                        noTextTipsLable.isHidden = true
                        bottomLine.snp.remakeConstraints { make in
                            make.top.equalTo(titleLabel.snp.bottom).offset(kMargin)
                            make.bottom.left.right.equalToSuperview()
                            make.height.equalTo(0.5)
                        }
                    } else {
                        noTextTipsLable.isHidden = false
                        
                        noTextTipsLable.snp.remakeConstraints { make in
                            make.top.equalTo(titleLabel.snp.bottom).offset(6)
                            make.height.equalTo(20)
                            make.left.equalTo(subHoldView.snp.left)
                            make.right.equalTo(subHoldView.snp.right)
                        }
                        
                        bottomLine.snp.remakeConstraints { make in
                            make.top.equalTo(noTextTipsLable.snp.bottom).offset(6)
                            make.left.right.equalToSuperview()
                            make.height.equalTo(0.5)
                            make.bottom.equalToSuperview()
                        }
                    }
                } else {
                    noTextTipsLable.isHidden = true
                    bottomLine.snp.remakeConstraints { make in
                        make.top.equalTo(titleLabel.snp.bottom).offset(kMargin)
                        make.bottom.left.right.equalToSuperview()
                        make.height.equalTo(0.5)
                    }
                }
            } else {
                noTextTipsLable.isHidden = true
                titleLabel.snp.remakeConstraints { make in
                    make.top.equalToSuperview().offset(kMargin)
                    make.left.equalToSuperview()
                    make.width.equalTo(80)
                    make.height.equalTo(20)
                }
                
                subHoldView.snp.remakeConstraints { make in
                    make.top.equalTo(titleLabel.snp.top)
                    make.bottom.equalTo(titleLabel.snp.bottom)
                    make.right.equalToSuperview()
                    make.left.equalTo(titleLabel.snp.right).offset(40)
                }
                
                bottomLine.snp.remakeConstraints { make in
                    make.top.equalTo(titleLabel.snp.bottom).offset(kMargin)
                    make.bottom.left.right.equalToSuperview()
                    make.height.equalTo(0.5)
                }
            }
            
            if showLongTimeButtonFlag {
                
                rightIcon.snp.removeConstraints()
                rightIcon.isHidden = true
                longTimeButton.snp.removeConstraints()
                longTimeButton.isHidden = false
                
                if longTimeButton.isSelected {
                    longTimeButton.snp.remakeConstraints { make in
                        make.left.equalTo(titleLabel.snp.right).offset(40)
                        make.centerY.equalTo(titleLabel)
                        make.height.equalTo(32)
                        make.width.equalTo(43)
                    }
                    
                    textField.snp.removeConstraints()
                    textField.snp.makeConstraints { make in
                        make.right.equalToSuperview()
                        make.bottom.top.left.equalToSuperview()
                    }
                } else {
                    longTimeButton.snp.remakeConstraints { make in
                        make.right.equalToSuperview()
                        make.centerY.equalTo(titleLabel)
                        make.height.equalTo(32)
                        make.width.equalTo(43)
                    }
                    
                    textField.snp.removeConstraints()
                    textField.snp.makeConstraints { make in
                        make.right.equalTo(longTimeButton.snp.left).offset(-4)
                        make.bottom.top.left.equalToSuperview()
                    }
                }
            } else {
                rightIcon.snp.removeConstraints()
                rightIcon.isHidden = false
                rightIcon.snp.makeConstraints { make in
                    make.centerY.equalToSuperview()
                    make.right.equalToSuperview()
                    make.width.height.equalTo(20)
                }
                
                longTimeButton.snp.removeConstraints()
                longTimeButton.isHidden = true
                
                textField.snp.removeConstraints()
                textField.snp.makeConstraints { make in
                    make.right.equalTo(rightIcon.snp.left).offset(-4)
                    make.bottom.top.left.equalToSuperview()
                }
                
            }
        } else if type == 2 {
            if needCheckFlag == true {
                titleLabel.snp.remakeConstraints { make in
                    make.top.equalToSuperview().offset(kMargin)
                    make.left.right.equalToSuperview()
                    make.height.equalTo(20)
                }

                subHoldView.snp.remakeConstraints { make in
                    make.top.equalTo(titleLabel.snp.bottom).offset(kMargin)
                    make.height.equalTo(20)
                    make.right.equalToSuperview()
                    make.left.equalToSuperview()
                }
                
                firstTextView.isHidden = true
                secondTextView.isHidden = true
                firstTextView.snp.removeConstraints()
                secondTextView.snp.removeConstraints()
                bottomLine.snp.removeConstraints()
                if textField.isEmpty == true {
                    noTextTipsLable.isHidden = false
                    noTextTipsLable.snp.remakeConstraints { make in
                        make.top.equalTo(subHoldView.snp.bottom).offset(6)
                        make.height.equalTo(20)
                        make.left.equalTo(subHoldView.snp.left)
                        make.right.equalTo(subHoldView.snp.right)
                    }
                    
                    bottomLine.snp.remakeConstraints { make in
                        make.top.equalTo(noTextTipsLable.snp.bottom).offset(6)
                        make.bottom.left.right.equalToSuperview()
                        make.height.equalTo(0.5)
                    }
                    
                } else {
                    noTextTipsLable.isHidden = true
                    
                    var lastView: UIView = subHoldView
                    if let text = textField.text, text.contains("其他") {
                        firstTextView.noTextTipsLable.text = "请输入其他专业技能的行业"
                        firstTextView.tipsLabel.text = "请输入其他专业技能的行业"
                        firstTextView.isHidden = false
                        firstTextView.snp.remakeConstraints { make in
                            make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                            make.left.right.equalToSuperview()
                        }
                        
                        firstTextView.needCheckFlag = needCheckFlag
                        lastView = firstTextView
                    } else if let text = textField.text, text.contains("中文及另一种外语") {
                        firstTextView.isHidden = false
                        secondTextView.isHidden = false
                        
                        firstTextView.noTextTipsLable.text = "请输入中文之外的语种"
                        firstTextView.tipsLabel.text = "请输入中文之外的语种"
                        firstTextView.snp.remakeConstraints { make in
                            make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                            make.left.right.equalToSuperview()
                        }
                        
                        secondTextView.noTextTipsLable.text = "请输入2年内获取的证书及分数"
                        secondTextView.tipsLabel.text = "请输入2年内获取的证书及分数"
                        secondTextView.snp.remakeConstraints { make in
                            make.top.equalTo(firstTextView.snp.bottom).offset(kMargin)
                            make.left.right.equalToSuperview()
                        }
                        
                        firstTextView.needCheckFlag = needCheckFlag
                        secondTextView.needCheckFlag = needCheckFlag
                        lastView = secondTextView
                    } else {
                    }
                    
                    bottomLine.snp.removeConstraints()
                    bottomLine.snp.remakeConstraints { make in
                        make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                        make.left.right.equalToSuperview()
                        make.height.equalTo(0.5)
                        make.bottom.equalToSuperview()
                    }
                }
            } else {
                
                noTextTipsLable.isHidden = true
                titleLabel.snp.remakeConstraints { make in
                    make.top.equalToSuperview().offset(kMargin)
                    make.left.right.equalToSuperview()
                    make.height.equalTo(20)
                }
                
                subHoldView.snp.remakeConstraints { make in
                    make.top.equalTo(titleLabel.snp.bottom).offset(kMargin)
                    make.height.equalTo(20)
                    make.right.equalToSuperview()
                    make.left.equalToSuperview()
                }
                
                firstTextView.snp.removeConstraints()
                secondTextView.snp.removeConstraints()
                
                firstTextView.isHidden = true
                secondTextView.isHidden = true
                
                var lastView: UIView = subHoldView
                
                if let text = textField.text, text.contains("其他") {
                    firstTextView.noTextTipsLable.text = "请输入其他专业技能的行业"
                    firstTextView.tipsLabel.text = "请输入其他专业技能的行业"
                    firstTextView.isHidden = false
                    firstTextView.snp.remakeConstraints { make in
                        make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                        make.left.right.equalToSuperview()
                    }
                    
                    firstTextView.needCheckFlag = needCheckFlag
                    lastView = firstTextView
                } else if let text = textField.text, text.contains("中文及另一种外语") {
                    firstTextView.isHidden = false
                    secondTextView.isHidden = false
                    
                    firstTextView.noTextTipsLable.text = "请输入中文之外的语种"
                    firstTextView.tipsLabel.text = "请输入中文之外的语种"
                    firstTextView.snp.remakeConstraints { make in
                        make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                        make.left.right.equalToSuperview()
                    }
                    
                    secondTextView.noTextTipsLable.text = "请输入2年内获取的证书及分数"
                    secondTextView.tipsLabel.text = "请输入2年内获取的证书及分数"
                    secondTextView.snp.remakeConstraints { make in
                        make.top.equalTo(firstTextView.snp.bottom).offset(kMargin)
                        make.left.right.equalToSuperview()
                    }
                    
                    firstTextView.needCheckFlag = needCheckFlag
                    secondTextView.needCheckFlag = needCheckFlag
                    lastView = secondTextView
                } else {
                }
                
                bottomLine.snp.removeConstraints()
                bottomLine.snp.remakeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                    make.left.right.equalToSuperview()
                    make.height.equalTo(0.5)
                    make.bottom.equalToSuperview()
                }
            }
        } else {
            printLog("error: 未处理的类型")
            
        }
        longTimeButton.iconInLeft(spacing: 3)
    }
}
