//
//  AppDelegate.swift
//  galaxy
//
//  Created by davidhuangA on 2023/12/19.
//

import UIKit
import ESTabBarController_swift
import IQKeyboardManagerSwift
import SmartCodable
import GKNavigationBarSwift
// import DeviceKit
import AVFoundation
import SensorsAnalyticsSDK

import AGConnectCore
import AGConnectCredential
import AGConnectAppLinking
import HyphenateChat
import TIMPush
import TUICore

@main
class AppDelegate: UIResponder, UIApplicationDelegate, WXApiDelegate {
    private lazy var liveViewModel = YHLiveSalesViewModel()
    var window: UIWindow?
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        
        Thread.sleep(forTimeInterval: 0.5) // 应产品同学Nick要求  启动页时间展示长点
    
        setupAudionConfig()
        
        // 初始化 神策sdk
        YHAnalytics.analyticsStart(launchOptions: launchOptions)
        
        // JPush服务注册
        registerJPushService(launchOptions)
        
        // 全局导航栏、返回事件/手势
        setupNavBar()
        
        // 2.通用UI设置
        setupWholeUI()
        
        // 3.其他第三方sdk设置
        thirdSetting()
        
        // 4.本地用户信息加载
        YHLoginManager.shared.loadLocalUserInfoData()
        
        YHConfigManager.shared.loadConfigData()
        
//        YHAnalytics.appInstall()
        
        // 5.预加载
        preloadOP()
        
        // 微信注册app
        WXApi.registerApp(YhConstant.Wechat.appKey, universalLink: YhConstant.Wechat.universalLink)
        WXApi.startLog(by: .detail) { string in
            printLog(string)
        }
        
        // 灰度规则配置
        YHUatHelper.shared.loadUatData()
        
        // 一键登录
        YHOneKeyLoginManager.shared.configOneKeyLogin()
        
        YHOSSManager.share.getOSSID()

        AGCInstance.startUp()
        AGCAppLinking.instance().handle { [weak self] (link, _) in
            guard let self = self else {
                return
            }
            if let deepLink = link?.deepLink, deepLink.contains(YhConstant.DeepLink.compareUrl) {
                if let url = URL(string: deepLink) {
                    let components = URLComponents(url: url, resolvingAgainstBaseURL: false)
                    if let queryItems = components?.queryItems {
                        var arrItems: [String: Any] = [:]
                        for item in queryItems {
                            if let value = item.value {
                                arrItems.updateValue(value, forKey: item.name)
                            }
                        }
                        
                        if arrItems.count > 0 {
                            if let type = arrItems["type"] as? String, let iType = Int(type) {
                                if iType == 1 {
                                    // 跳转直播
                                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.25) {
                                        if !YHLoginManager.shared.isLogin() {
                                            printLog("需要登录")
                                            return
                                        }
                                        // 直播 - 获取它对应的参数
                                        if let liveId = arrItems["LiveID"] as? String {
                                            if let userId = arrItems["fromUserId"] as? String, let sourceType = arrItems["sourceType"] as? String {
                                                self.liveViewModel.postLiveViewRecords(id: liveId.intValue(), userId: userId, sourceType: sourceType.intValue()) { _, _ in
                                                    //
                                                }
                                            }
                                            
                                            let playbackInfo = YHPlayerManager.PlaybackInfo(id: liveId.intValue(), isLive: true, isFromSaleDetail: false)
                                            YHPlayerManager.shared.enterLive(from: nil, playbackInfo: playbackInfo)
                                        }
                                    }
                                } else if iType == 3 {
                                    // VodID
                                    // 点播分享
                                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.25) {
                                        if !YHLoginManager.shared.isLogin() {
                                            printLog("需要登录")
                                            return
                                        }
                                        // 直播 - 获取它对应的参数
                                        if let liveId = arrItems["VodID"] as? String {
                                            let playbackInfo = YHPlayerManager.PlaybackInfo(id: liveId.intValue(), url: nil, title: nil, roomId: nil, uid: nil, isLive: false, scene: .fullscreen)
                                            YHPlayerManager.shared.enterVOD(from: nil, playbackInfo: playbackInfo)
                                        }
                                    }
                                } else if iType == 4 {
                                    // 跳转商品详情
                                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.25) {
                                        // - 获取它对应的参数
                                        if let goodsId = arrItems["id"] as? String {
                                            NotificationCenter.default.post(name: YhConstant.YhNotification.closeShareUIInLiveRoomNotifiction, object: nil)
                                            
                                            let shareYinheID = arrItems["shareYinheID"] as? String ?? ""
                                            
                                            var url = YHBaseUrlManager.shared.curH5URL() + "superAppBridge.html#/goods/sales-detail" + "?id=\(goodsId)&shareYinheID=\(shareYinheID)"
                                            if YHLoginManager.shared.isLogin() {
                                                let token = YHLoginManager.shared.h5Token
                                                url = url + "&param=" + token
                                            }
                                            var tUrl = url
                                            if !url.contains("navigationH=") {
                                                tUrl = url + "?navigationH=\(k_Height_NavigationtBarAndStatuBar)"
                                                if url.contains("?") {
                                                    tUrl = url + "&navigationH=\(k_Height_NavigationtBarAndStatuBar)"
                                                }
                                            }
                                            let vc = YHH5WebViewVC()
                                            vc.url = tUrl
                                            vc.isHideNavigationBar = false
                                            UIViewController.current?.navigationController?.pushViewController(vc, animated: true)
                                        }
                                    }
                                } else if iType == 5 {
                                    // 跳转商品详情
                                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.25) {
                                        if !YHLoginManager.shared.isLogin() {
                                            printLog("需要登录")
                                            return
                                        }
                                        let surveyViewModel = YHSurveyViewModel()
                                        // 跳转分析
                                        surveyViewModel.getRenewalPlanGenerated { state, error in
                                            guard let state = state else {
                                                if let msg = error?.errorMsg, !msg.isEmpty {
                                                    YHHUD.flash(message: msg)
                                                }
                                                return
                                            }
                                            if state.isGeneratePlan == true {
                                                let vc = YHPlanTestViewController()
                                                UIViewController.current?.navigationController?.pushViewController(vc)
                                            } else {
                                                let vc = YHCustomerInformationQuestionnaireVC()
                                                UIViewController.current?.navigationController?.pushViewController(vc)
                                            }
                                        }
                                    }
                                } else if iType == 6 {
                                    // 跳转方案商品
                                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.25) {
                                        // - 获取它对应的参数
                                        if !YHLoginManager.shared.isLogin() {
                                            printLog("需要登录")
                                            return
                                        }
                                        let surveyViewModel = YHSurveyViewModel()
                                        surveyViewModel.getRenewalPlanGenerated { state, error in
                                            guard let state = state else {
                                                if let msg = error?.errorMsg, !msg.isEmpty {
                                                    YHHUD.flash(message: msg)
                                                }
                                                return
                                            }
                                            if state.isGeneratePlan == true {
                                                let vc = YHMakePlanViewController()
                                                UIViewController.current?.navigationController?.pushViewController(vc, animated: true)
                                            } else {
                                                let vc = YHCustomerInformationQuestionnaireVC()
                                                UIViewController.current?.navigationController?.pushViewController(vc)
                                            }
                                        }
                                    }
                                } else {
                                    printLog("未处理的类型 \(iType)")
                                }
                            }
                        }
                    }
                }
            }
        }
        
        // QiYu SDK初始化
        YHButlerServiceManager.shared.setupSDK()
        setupTUITheme()
//        YHTencentDeskManager.shared.loginIM()
        _ = YHTencentDeskManager.shared
        
        // 初始化 环信IM SDK
        DispatchQueue.main.async {
            let options: EMOptions = EMOptions(appkey: YhConstant.IM.appKey)
            options.isAutoLogin = false
            EMClient.shared().initializeSDK(with: options)
            _ = YHIMHelper.sharedHelper()
        }
        
        // 设置主窗口
        setupRootVC()
        return true
    }
    
    func application(_ application: UIApplication, supportedInterfaceOrientationsFor window: UIWindow?) -> UIInterfaceOrientationMask {
        if UIDevice.current.userInterfaceIdiom == .pad {
            let vc = UIViewController.current ?? UIViewController()
            if vc.isKind(of: YHLivePlayerViewController.self) {
                if let vc2 = vc as? YHLivePlayerViewController, vc2.canDoRotateFunc() {
                    return [.portrait, .landscapeRight]
                }
            }
            return .portrait
        } else {
            let vc = UIViewController.current ?? UIViewController()
            if vc.isKind(of: YHLivePlayerViewController.self) {
                if let vc2 = vc as? YHLivePlayerViewController, vc2.canDoRotateFunc() {
                    return [.portrait, .landscapeRight]
                }
            }
            return .portrait
        }
    }
    
    func application(_ app: UIApplication, open url: URL, options: [UIApplication.OpenURLOptionsKey: Any] = [:]) -> Bool {
        
        if let host = url.host, host.contains("platformId=wechat") {
            return WXApi.handleOpen(url, delegate: self)
        }
        if YHAnalytics.handleSchemeUrl(url) ?? false {
            return true
        }
        return true
    }
    
    func setupNavBar() {
        GKConfigure.setupDefault()
    }
    
    func application(_ application: UIApplication, handleOpen url: URL) -> Bool {
        return WXApi.handleOpen(url, delegate: self)
    }
    
    func application(_ application: UIApplication, open url: URL, sourceApplication: String?, annotation: Any) -> Bool {
        return WXApi.handleOpen(url, delegate: self)
    }
    
//    private func application(_ application: UIApplication, continue userActivity: NSUserActivity, restorationHandler: @escaping ([UIUserActivityRestoring]?) -> Void) -> Bool {
//
//        return isAppLinking
//    }
    
    func application(_ application: UIApplication, continue userActivity: NSUserActivity, restorationHandler: @escaping ([UIUserActivityRestoring]?) -> Void) -> Bool {
        let isAppLinking = AGCAppLinking.instance().continueUserActivity(userActivity)
        return  isAppLinking == false ? WXApi.handleOpenUniversalLink(userActivity, delegate: self) : true
    }
    
    func application(_ application: UIApplication, continue userActivity: NSUserActivity, restorationHandler: @escaping ([Any]?) -> Void) -> Bool {
        let isAppLinking = AGCAppLinking.instance().continueUserActivity(userActivity)
        return isAppLinking == false ? WXApi.handleOpenUniversalLink(userActivity, delegate: self) : true
    }
    
    func onResp(_ resp: BaseResp) {
        if resp.isKind(of: SendAuthResp.self) {
            let res = resp as? SendAuthResp
            if res?.state == "wechat_sdk_demo_test", let code = res?.code {
                YHShareManager.shared.getWechatAccessToken(code: code)
            }
            
        } else if resp.isKind(of: WXLaunchMiniProgramResp.self) { // 微信小程序回调
            let res = resp as? WXLaunchMiniProgramResp
            if let extMsg = res?.extMsg {
                if extMsg == "my_certificate" { // 我的证件 微信文件上传
                    NotificationCenter.default.post(name: YhConstant.YhNotification.didMyCertificateWeChatFileUploadCallBackNotification, object: nil)
                    
                } else if extMsg == "wx_upload_renewal_data" {
                    NotificationCenter.default.post(name: YhConstant.YhNotification.didMyResignMaterialWeChatFileUploadCallBackNotification, object: nil)
                    
                } else if extMsg == "wx_upload_sign_apply" {
                    NotificationCenter.default.post(name: YhConstant.YhNotification.didMySignWeChatFileUploadCallBackNotification, object: nil)
                }
                
            }
        }
    }
}

extension AppDelegate {
    private func thirdSetting() {
        // 1.数据解析
#if DEBUG
        SmartConfig.debugMode = .none
#elseif TESTENV
        SmartConfig.debugMode = .none
#else
        SmartConfig.debugMode = .none
#endif
        
        // 2.bugly参数设置
#if DEBUG
        Bugly.start(withAppId: YhConstant.Bugly.appidForTest)
#elseif TESTENV
        Bugly.start(withAppId: YhConstant.Bugly.appidForTest)
#else
        Bugly.start(withAppId: YhConstant.Bugly.appidForRelease)
#endif

    }
    
    // 2.通用全局UI设置相关
    private func setupWholeUI() {
        
        DispatchQueue.global().async {
            // 异步延迟设置
            DispatchQueue.main.asyncAfter(wallDeadline: .now() + 0.25) { [] in
                // 1、系统控件属性设置
                UITextField.appearance().tintColor = .brandMainColor
                UITextView.appearance().tintColor = .brandMainColor
                
                IQKeyboardManager.shared.isEnabled = true
                IQKeyboardManager.shared.enableAutoToolbar = false
                IQKeyboardManager.shared.resignOnTouchOutside = true  // 控制点击背景是否收起键盘
                IQKeyboardManager.shared.keyboardDistance = 10 // 输入框距离键盘的距离
            }
        }
        
        YHNetworkStatusManager.shared.listenNetWorkStatus()
    }
    
    // 1.设置闪主窗口
    private func setupRootVC() {
        
        let dateString = Date().dateString(ofStyle: .short)
        let oldString = UserDefaults.standard.value(forKey: "todayShowStartPageViewFlag")
        
        if  let tempStr =  oldString as? String, tempStr == dateString {
            setupRootVCWithTabBar()
        } else {
            let nav = YHNavigationController(rootVC: YHStartPageViewController())
            window = UIWindow(frame: UIScreen.main.bounds)
            window?.rootViewController = nav
            window?.makeKeyAndVisible()
        }
        
    }
    
    // 1.设置HomePageView为主窗口
    func setupRootVCWithTabBar() {
     
        window = UIWindow(frame: UIScreen.main.bounds)
        window?.rootViewController = configTabBarController()
        window?.makeKeyAndVisible()
        
        if YHLoginManager.shared.needJumpToMsgTabFlag {
            DispatchQueue.main.asyncAfter(deadline: .now() + 0.25, execute: {
                goToMessagePage()
            })
        }
    }
    
    private func preloadOP() {
        DispatchQueue.global().async {
            guard let videoURL = Bundle.main.url(forResource: "loginBkg", withExtension: "mov") else { return }
            
            let player: AVPlayer? = AVPlayer(url: videoURL)
            player?.actionAtItemEnd = .none
            let playerLayer: AVPlayerLayer? = AVPlayerLayer(player: player)
            playerLayer?.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight)
            playerLayer?.videoGravity = .resizeAspectFill
            player?.play()
            player?.pause()
        }
    }
    
    private func setupAudionConfig() {
        
        // 确保 AVAudioSession 被正确配置,以便在静音模式下也能正常播放音频
        do {
            try AVAudioSession.sharedInstance().setCategory(.playback, mode: .moviePlayback, options: .mixWithOthers)
            try AVAudioSession.sharedInstance().setActive(true)
                    
        } catch let error as NSError {
            print("error: \(error.localizedDescription)")
        }
    }
}

extension AppDelegate: TIMPushDelegate {
    func businessID() -> Int32 {
        return YhConstant.TencentIMSDKInfo.certificateId
    }
    
//    func applicationGroupID() -> String {
//        return ""
//    }
    
    func navigateToBuiltInChatViewController(userID: String?, groupID: String?) {
        //
    }
}

extension AppDelegate {
    private func setupTUITheme() {
        // 自定义修改 TUIChat 组件的主题 - 在主题资源包中新增了一套主题
        guard let customChatThemePath = Bundle.main.path(forResource: "TUIChatCustomTheme", ofType: "bundle") else {
            return
        }
        TUIThemeManager.share().registerThemeResourcePath(customChatThemePath, for: .chat)
        // 应用主题，根据 themeID 对 TUIChat 设置主题
        TUIThemeManager.share().applyTheme("enterprise", for: .chat)
    }
}
