//
//  YHBaseDynamicCornerRadiusView.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHBaseDynamicCornerRadiusView: UIView {

    public var radius: CGFloat = 8
    public var corner: UIRectCorner? {
        didSet {
            if corner != oldValue {
                layoutSubviews()
            }
        }
    }
    
    public init(cornerRadius: CGFloat, corner: UIRectCorner? = nil) {
        self.corner = corner
        self.radius = cornerRadius
        super.init(frame: CGRect.zero)
    }
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private var boarderLayer: CAShapeLayer?
    
    private var viewBounds = CGRect.zero {
        didSet {
            boarderLayer?.removeFromSuperlayer()
            boarderLayer = nil
            if let corner = corner {
                boarderLayer =  createCorner(CGSize(width: radius, height: radius), corner)
            }
        }
    }
    
    override public func layoutSubviews() {
        super.layoutSubviews()
        viewBounds = bounds
    }
}
