//
//  YHAIChatBannerCollectionCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIChatBannerCollectionCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHAIChatBannerCollectionCell"

    lazy var bgView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.backgroundColor = .white
        v.layer.cornerRadius = 6.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var titleLabel: UILabel =  {
        var label = UILabel()
        label.font = .PFSC_M(ofSize: 12)
        label.textAlignment = .left
        label.textColor = UIColor(hex: 0x6D788A)
        return label
    }()
    
    lazy var shadowView: YHAIFlowMessageShadowView = {
        let v = YHAIFlowMessageShadowView()
        return v
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    private func setupUI() {
        
        contentView.addSubview(shadowView)
        contentView.addSubview(bgView)
        bgView.addSubview(titleLabel)
        
        bgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        shadowView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(10.0)
            make.right.equalToSuperview().offset(-10.0)
        }
    }
    
}
