//
//  YHAIChatBannerItemCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSPagerView
import VisualEffectView

class YHAIChatBannerItemCell: FSPagerViewCell {
    
    var model = YHAIChatBannerItem() {
        didSet {
            titleLabel.text = model.title
            subtitleLabel.text = model.desc
        }
    }
    
    static let cellReuseIdentifier = "YHAIChatBannerItemCell"

//    lazy var effectView:VisualEffectView = {
//        let visualEffectView = VisualEffectView()
//        visualEffectView.colorTint = UIColor(hex: 0xAFAFAF).withAlphaComponent(0.15)
//        visualEffectView.blurRadius = 16
//        visualEffectView.scale = 1
//        visualEffectView.isHidden = true
//        return visualEffectView
//    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.font = UIFont.PFSC_B(ofSize: 14)
        lable.textColor = UIColor.brandMainColor
        lable.text = "银河明星产品"
        return lable
    }()
    
    lazy var subtitleLabel: UILabel = {
        let lable = UILabel()
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.mainTextColor
        lable.text = "这里是副标题"
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func initView() {
        
        contentView.layer.shadowColor = UIColor.clear.cgColor
        contentView.layer.shadowRadius = 0
        contentView.layer.shadowOpacity = 0
        contentView.layer.shadowOffset = .zero
        
//        contentView.addSubview(effectView)
//        effectView.snp.makeConstraints { make in
//            make.bottom.left.right.equalToSuperview()
//            make.height.equalTo(95)
//        }
        
        contentView.addSubview(subtitleLabel)
        subtitleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(20)
            make.bottom.equalTo(-35)
        }
        
        contentView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(24)
            make.bottom.equalTo(subtitleLabel.snp.top)
        }
        
    }
}
